/*
 * Decompiled with CFR 0.152.
 */
package com.io7m.jxe.core;

import com.io7m.jxe.core.JXESchemaDefinition;
import com.io7m.jxe.core.JXESchemaResolutionMappings;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class JXESchemaDefinitions {
    private JXESchemaDefinitions() {
    }

    public static Map<URI, JXESchemaDefinition> mapOf(JXESchemaDefinition ... schemas) {
        Objects.requireNonNull(schemas, "schemas");
        return JXESchemaDefinitions.mapOfList(List.of(schemas));
    }

    public static Map<URI, JXESchemaDefinition> mapOfList(List<JXESchemaDefinition> schemas) {
        Objects.requireNonNull(schemas, "schemas");
        return schemas.stream().collect(Collectors.toMap(JXESchemaDefinition::namespace, Function.identity()));
    }

    public static JXESchemaResolutionMappings mappingsOf(JXESchemaDefinition ... schemas) {
        Objects.requireNonNull(schemas, "schemas");
        return JXESchemaResolutionMappings.builder().putAllMappings(JXESchemaDefinitions.mapOf(schemas)).build();
    }

    public static JXESchemaResolutionMappings mappingsOfList(List<JXESchemaDefinition> schemas) {
        Objects.requireNonNull(schemas, "schemas");
        return JXESchemaResolutionMappings.builder().putAllMappings(JXESchemaDefinitions.mapOfList(schemas)).build();
    }
}

