/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.metadata.tiff;

import com.twelvemonkeys.imageio.metadata.CompoundDirectory;
import com.twelvemonkeys.imageio.metadata.Directory;
import com.twelvemonkeys.imageio.metadata.Entry;
import com.twelvemonkeys.imageio.metadata.MetadataWriter;
import com.twelvemonkeys.imageio.metadata.tiff.IFD;
import com.twelvemonkeys.imageio.metadata.tiff.Rational;
import com.twelvemonkeys.imageio.metadata.tiff.TIFFEntry;
import com.twelvemonkeys.lang.Validate;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import javax.imageio.IIOException;
import javax.imageio.stream.ImageOutputStream;

public final class TIFFWriter
extends MetadataWriter {
    private static final int WORD_LENGTH = 2;
    private static final int LONGWORD_LENGTH = 4;
    private static final int ENTRY_LENGTH = 12;

    public boolean write(Collection<Entry> collection, ImageOutputStream imageOutputStream) throws IOException {
        return this.write(new IFD(collection), imageOutputStream);
    }

    @Override
    public boolean write(Directory directory, ImageOutputStream imageOutputStream) throws IOException {
        Validate.notNull(directory);
        Validate.notNull(imageOutputStream);
        this.writeTIFFHeader(imageOutputStream);
        if (directory instanceof CompoundDirectory) {
            CompoundDirectory compoundDirectory = (CompoundDirectory)directory;
            for (int i = 0; i < compoundDirectory.directoryCount(); ++i) {
                this.writeIFD(compoundDirectory.getDirectory(i), imageOutputStream, false);
            }
        } else {
            this.writeIFD(directory, imageOutputStream, false);
        }
        imageOutputStream.writeInt(0);
        return true;
    }

    public void writeTIFFHeader(ImageOutputStream imageOutputStream) throws IOException {
        ByteOrder byteOrder = imageOutputStream.getByteOrder();
        imageOutputStream.writeShort(byteOrder == ByteOrder.BIG_ENDIAN ? 19789 : 18761);
        imageOutputStream.writeShort(42);
    }

    public long writeIFD(Collection<Entry> collection, ImageOutputStream imageOutputStream) throws IOException {
        Validate.notNull(collection);
        Validate.notNull(imageOutputStream);
        return this.writeIFD(new IFD(collection), imageOutputStream, false);
    }

    private long writeIFD(Directory directory, ImageOutputStream imageOutputStream, boolean bl) throws IOException {
        Directory directory2 = this.ensureOrderedDirectory(directory);
        long l = imageOutputStream.getStreamPosition();
        long l2 = this.computeDataSize(directory2);
        long l3 = imageOutputStream.getStreamPosition() + l2 + 4L;
        if (!bl) {
            imageOutputStream.writeInt(this.assertIntegerOffset(l3));
            l += 4L;
            imageOutputStream.seek(l3);
        } else {
            l += (long)(2 + directory2.size() * 12);
        }
        imageOutputStream.writeShort(directory2.size());
        for (Entry entry : directory2) {
            imageOutputStream.writeShort((Integer)entry.getIdentifier());
            imageOutputStream.writeShort(TIFFEntry.getType(entry));
            imageOutputStream.writeInt(this.getCount(entry));
            if (entry.getValue() instanceof Directory) {
                imageOutputStream.writeInt(this.assertIntegerOffset(l));
                long l4 = imageOutputStream.getStreamPosition();
                imageOutputStream.seek(l);
                Directory directory3 = (Directory)entry.getValue();
                this.writeIFD(directory3, imageOutputStream, true);
                l += this.computeDataSize(directory3);
                imageOutputStream.seek(l4);
                continue;
            }
            l += this.writeValue(entry, l, imageOutputStream);
        }
        return l3;
    }

    public long computeIFDSize(Collection<Entry> collection) {
        return 2L + this.computeDataSize(new IFD(collection)) + (long)(collection.size() * 12);
    }

    private long computeDataSize(Directory directory) {
        long l = 0L;
        for (Entry entry : directory) {
            long l2 = TIFFEntry.getValueLength(TIFFEntry.getType(entry), this.getCount(entry));
            if (l2 < 0L) {
                throw new IllegalArgumentException(String.format("Unknown size for entry %s", entry));
            }
            if (l2 > 4L) {
                l += l2;
            }
            if (!(entry.getValue() instanceof Directory)) continue;
            Directory directory2 = (Directory)entry.getValue();
            long l3 = (long)(2 + directory2.size() * 12) + this.computeDataSize(directory2);
            l += l3;
        }
        return l;
    }

    private Directory ensureOrderedDirectory(Directory directory) {
        if (!this.isSorted(directory)) {
            ArrayList<Entry> arrayList = new ArrayList<Entry>(directory.size());
            for (Entry entry : directory) {
                arrayList.add(entry);
            }
            Collections.sort(arrayList, new Comparator<Entry>(){

                @Override
                public int compare(Entry entry, Entry entry2) {
                    return (Integer)entry.getIdentifier() - (Integer)entry2.getIdentifier();
                }
            });
            return new IFD(arrayList);
        }
        return directory;
    }

    private boolean isSorted(Directory directory) {
        int n = 0;
        for (Entry entry : directory) {
            int n2 = (Integer)entry.getIdentifier() & 0xFFFF;
            if (n2 < n) {
                return false;
            }
            n = n2;
        }
        return true;
    }

    private long writeValue(Entry entry, long l, ImageOutputStream imageOutputStream) throws IOException {
        short s2 = TIFFEntry.getType(entry);
        long l2 = TIFFEntry.getValueLength(s2, this.getCount(entry));
        if (l2 <= 4L) {
            this.writeValueInline(entry.getValue(), s2, imageOutputStream);
            for (long i = l2; i < 4L; ++i) {
                imageOutputStream.write(0);
            }
            return 0L;
        }
        this.writeValueAt(l, entry.getValue(), s2, imageOutputStream);
        return l2;
    }

    private int getCount(Entry entry) {
        Object object = entry.getValue();
        return object instanceof String ? ((String)object).getBytes(Charset.forName("UTF-8")).length + 1 : entry.valueCount();
    }

    private void writeValueInline(Object object, short s2, ImageOutputStream imageOutputStream) throws IOException {
        block34: {
            block33: {
                if (!object.getClass().isArray()) break block33;
                switch (s2) {
                    case 1: 
                    case 6: 
                    case 7: {
                        imageOutputStream.write((byte[])object);
                        break;
                    }
                    case 3: 
                    case 8: {
                        short[] sArray;
                        if (object instanceof short[]) {
                            sArray = (short[])object;
                        } else if (object instanceof int[]) {
                            int[] nArray = (int[])object;
                            sArray = new short[nArray.length];
                            for (int i = 0; i < nArray.length; ++i) {
                                sArray[i] = (short)nArray[i];
                            }
                        } else if (object instanceof long[]) {
                            long[] lArray = (long[])object;
                            sArray = new short[lArray.length];
                            for (int i = 0; i < lArray.length; ++i) {
                                sArray[i] = (short)lArray[i];
                            }
                        } else {
                            throw new IllegalArgumentException("Unsupported type for TIFF SHORT: " + object.getClass());
                        }
                        imageOutputStream.writeShorts(sArray, 0, sArray.length);
                        break;
                    }
                    case 4: 
                    case 9: {
                        int[] nArray;
                        if (object instanceof int[]) {
                            nArray = (int[])object;
                        } else if (object instanceof long[]) {
                            long[] lArray = (long[])object;
                            nArray = new int[lArray.length];
                            for (int i = 0; i < lArray.length; ++i) {
                                nArray[i] = (int)lArray[i];
                            }
                        } else {
                            throw new IllegalArgumentException("Unsupported type for TIFF LONG: " + object.getClass());
                        }
                        imageOutputStream.writeInts(nArray, 0, nArray.length);
                        break;
                    }
                    case 5: 
                    case 10: {
                        Rational[] rationalArray;
                        for (Rational rational : rationalArray = (Rational[])object) {
                            imageOutputStream.writeInt((int)rational.numerator());
                            imageOutputStream.writeInt((int)rational.denominator());
                        }
                        break block34;
                    }
                    case 11: {
                        if (!(object instanceof float[])) {
                            throw new IllegalArgumentException("Unsupported type for TIFF FLOAT: " + object.getClass());
                        }
                        float[] fArray = (float[])object;
                        imageOutputStream.writeFloats(fArray, 0, fArray.length);
                        break;
                    }
                    case 12: {
                        if (!(object instanceof double[])) {
                            throw new IllegalArgumentException("Unsupported type for TIFF FLOAT: " + object.getClass());
                        }
                        double[] dArray = (double[])object;
                        imageOutputStream.writeDoubles(dArray, 0, dArray.length);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported TIFF type: " + s2);
                    }
                }
                break block34;
            }
            switch (s2) {
                case 1: 
                case 6: 
                case 7: {
                    imageOutputStream.writeByte(((Number)object).intValue());
                    break;
                }
                case 2: {
                    byte[] byArray = ((String)object).getBytes(StandardCharsets.UTF_8);
                    imageOutputStream.write(byArray);
                    imageOutputStream.write(0);
                    break;
                }
                case 3: 
                case 8: {
                    imageOutputStream.writeShort(((Number)object).intValue());
                    break;
                }
                case 4: 
                case 9: {
                    imageOutputStream.writeInt(((Number)object).intValue());
                    break;
                }
                case 5: 
                case 10: {
                    Rational rational = (Rational)object;
                    imageOutputStream.writeInt((int)rational.numerator());
                    imageOutputStream.writeInt((int)rational.denominator());
                    break;
                }
                case 11: {
                    imageOutputStream.writeFloat(((Number)object).floatValue());
                    break;
                }
                case 12: {
                    imageOutputStream.writeDouble(((Number)object).doubleValue());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported TIFF type: " + s2);
                }
            }
        }
    }

    private void writeValueAt(long l, Object object, short s2, ImageOutputStream imageOutputStream) throws IOException {
        imageOutputStream.writeInt(this.assertIntegerOffset(l));
        long l2 = imageOutputStream.getStreamPosition();
        imageOutputStream.seek(l);
        this.writeValueInline(object, s2, imageOutputStream);
        imageOutputStream.seek(l2);
    }

    private int assertIntegerOffset(long l) throws IIOException {
        if (l > 0xFFFFFFFFL) {
            throw new IIOException("Integer overflow for TIFF stream");
        }
        return (int)l;
    }
}

