/*
 * Decompiled with CFR 0.152.
 */
package dataflow.cfg.node;

import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.Tree;
import dataflow.cfg.node.Node;
import dataflow.cfg.node.NodeVisitor;
import dataflow.util.HashCodeUtils;
import java.util.Collection;
import java.util.LinkedList;
import javacutils.InternalUtils;

public class ArrayAccessNode
extends Node {
    protected Tree tree;
    protected Node array;
    protected Node index;

    public ArrayAccessNode(Tree t, Node array, Node index) {
        super(InternalUtils.typeOf(t));
        assert (t instanceof ArrayAccessTree);
        this.tree = t;
        this.array = array;
        this.index = index;
    }

    public Node getArray() {
        return this.array;
    }

    public Node getIndex() {
        return this.index;
    }

    @Override
    public Tree getTree() {
        return this.tree;
    }

    @Override
    public <R, P> R accept(NodeVisitor<R, P> visitor, P p) {
        return visitor.visitArrayAccess(this, p);
    }

    public String toString() {
        String base = this.getArray().toString() + "[" + this.getIndex().toString() + "]";
        return base;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ArrayAccessNode)) {
            return false;
        }
        ArrayAccessNode other = (ArrayAccessNode)obj;
        return this.getArray().equals(other.getArray()) && this.getIndex().equals(other.getIndex());
    }

    public int hashCode() {
        return HashCodeUtils.hash(this.getArray(), this.getIndex());
    }

    @Override
    public Collection<Node> getOperands() {
        LinkedList<Node> list = new LinkedList<Node>();
        list.add(this.getArray());
        list.add(this.getIndex());
        return list;
    }
}

