/*
 * Decompiled with CFR 0.152.
 */
package net.coobird.thumbnailator.filters;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import net.coobird.thumbnailator.builders.BufferedImageBuilder;
import net.coobird.thumbnailator.filters.ImageFilter;
import net.coobird.thumbnailator.util.BufferedImages;

public class Transparency
implements ImageFilter {
    private final AlphaComposite composite;

    public Transparency(float f) {
        if (f < 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("The alpha must be between 0.0f and 1.0f, inclusive.");
        }
        this.composite = AlphaComposite.getInstance(3, f);
    }

    public Transparency(double d) {
        this((float)d);
    }

    public BufferedImage apply(BufferedImage bufferedImage) {
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        BufferedImage bufferedImage2 = new BufferedImageBuilder(n, n2, 2).build();
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.setComposite(this.composite);
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        graphics2D.dispose();
        if (bufferedImage.getType() != bufferedImage2.getType()) {
            return BufferedImages.copy(bufferedImage2, bufferedImage.getType());
        }
        return bufferedImage2;
    }

    public float getAlpha() {
        return this.composite.getAlpha();
    }
}

