/*
 * Decompiled with CFR 0.152.
 */
package one.lfa.epubsquash.vanilla.internal;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;
import one.lfa.epubsquash.api.EPUBSquasherConfiguration;
import one.lfa.epubsquash.api.EPUBSquasherType;
import one.lfa.epubsquash.vanilla.internal.EPUBDeletionVisitor;
import one.lfa.epubsquash.vanilla.internal.EPUBImageSize;
import one.lfa.epubsquash.vanilla.internal.EPUBImageSquasher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EPUBSquasher
implements EPUBSquasherType {
    private static final Logger LOG = LoggerFactory.getLogger(EPUBSquasher.class);
    private static final Instant TIMESTAMP = LocalDateTime.of(2001, 1, 1, 0, 0, 0).toInstant(ZoneOffset.UTC);
    private final EPUBSquasherConfiguration configuration;
    private final AtomicBoolean squashed;
    private final TreeMap<String, Path> unpacked;
    private final EPUBImageSquasher image_squasher;

    public EPUBSquasher(EPUBSquasherConfiguration in_configuration) {
        this.configuration = Objects.requireNonNull(in_configuration, "configuration");
        this.squashed = new AtomicBoolean(false);
        this.unpacked = new TreeMap();
        this.image_squasher = new EPUBImageSquasher();
    }

    private static void repack(Path temp, Path output_file) throws IOException {
        try (OutputStream stream = Files.newOutputStream(output_file, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
             ZipOutputStream zip_out = new ZipOutputStream(stream, StandardCharsets.UTF_8);){
            List copies = Files.walk(temp, new FileVisitOption[0]).filter(path -> Files.isRegularFile(path, new LinkOption[0])).filter(path -> !path.getFileName().startsWith("TMP_")).map(path -> new Copy((Path)path, temp.relativize((Path)path).toString())).collect(Collectors.toList());
            Copy meta = copies.stream().filter(copy -> "mimetype".equals(copy.name)).findFirst().orElseThrow();
            EPUBSquasher.packCopy(zip_out, meta);
            for (Copy copy2 : copies) {
                if (Objects.equals(copy2.name, "mimetype")) continue;
                EPUBSquasher.packCopy(zip_out, copy2);
            }
        }
    }

    private static void packCopy(ZipOutputStream zip_out, Copy copy) throws IOException {
        LOG.debug("pack: {}", (Object)copy.input);
        ZipEntry entry = new ZipEntry(copy.name);
        long size = Files.size(copy.input);
        entry.setSize(size);
        CRC32 crc32 = new CRC32();
        byte[] buffer = new byte[8192];
        try (InputStream stream = Files.newInputStream(copy.input, StandardOpenOption.READ);){
            int r;
            while ((r = stream.read(buffer)) != -1) {
                crc32.update(buffer, 0, r);
            }
            entry.setCrc(crc32.getValue());
        }
        entry.setCreationTime(FileTime.from(TIMESTAMP));
        entry.setLastAccessTime(FileTime.from(TIMESTAMP));
        entry.setLastModifiedTime(FileTime.from(TIMESTAMP));
        entry.setMethod(8);
        entry.setExtra(new byte[0]);
        zip_out.putNextEntry(entry);
        Files.copy(copy.input, zip_out);
        Files.delete(copy.input);
        Path parent = copy.input.getParent();
        if (parent != null && Files.isDirectory(parent, new LinkOption[0])) {
            try {
                Files.delete(parent);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void deleteRecursive(Path directory) throws IOException {
        Files.walkFileTree(directory, new EPUBDeletionVisitor(LOG));
    }

    @Override
    public void squash() throws IOException {
        if (!this.squashed.compareAndSet(false, true)) {
            throw new IllegalStateException("Squasher has already executed");
        }
        this.runSquash();
    }

    private void runSquash() throws IOException {
        Path temp = this.configuration.temporaryDirectory();
        Files.createDirectories(temp, new FileAttribute[0]);
        try {
            this.runUnpack(temp);
            this.runImages();
            EPUBSquasher.repack(temp, this.configuration.outputFile());
        }
        finally {
            EPUBSquasher.deleteRecursive(temp);
        }
    }

    private EPUBImageSize calculateImageSize(Path path, int width, int height) {
        int mWidth = width;
        int mHeight = height;
        double scale = this.configuration.scale();
        if (scale != 1.0) {
            mWidth = (int)((double)width * scale);
            mHeight = (int)((double)height * scale);
        }
        double aspect = (double)height / (double)width;
        double maxWidth = this.configuration.maximumImageWidth();
        double maxHeight = this.configuration.maximumImageHeight();
        if ((double)mWidth > maxWidth && (double)mHeight > maxHeight) {
            mHeight = (int)((double)mHeight * aspect);
        }
        LOG.debug("rescaling {}: {}x{} -> {}x{}", path, (double)width, (double)height, (double)mWidth, (double)mHeight);
        return new EPUBImageSize(mWidth, mHeight);
    }

    private void runImages() throws IOException {
        for (Map.Entry<String, Path> entry : this.unpacked.entrySet()) {
            Path path = entry.getValue();
            if (!this.image_squasher.isImage(path)) continue;
            LOG.info("squashing: {}", (Object)path);
            BufferedImage image = ImageIO.read(path.toFile());
            EPUBImageSize scaled = this.calculateImageSize(path, image.getWidth(), image.getHeight());
            this.image_squasher.squashImage(path, path.resolveSibling("TMP_" + path.getFileName()), path, scaled.width(), scaled.height());
        }
    }

    private void runUnpack(Path temp) throws IOException {
        try (ZipFile input_zip = new ZipFile(this.configuration.inputFile().toFile(), 1);){
            Enumeration<? extends ZipEntry> entries = input_zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                Path output_path = temp.resolve(entry.getName()).toAbsolutePath();
                if (entry.isDirectory()) {
                    LOG.debug("mkdir: {}", (Object)temp);
                    Files.createDirectories(temp, new FileAttribute[0]);
                } else {
                    Path parent = output_path.getParent();
                    if (parent != null && !Files.exists(parent, new LinkOption[0])) {
                        LOG.debug("mkdir: {}", (Object)parent);
                        Files.createDirectories(parent, new FileAttribute[0]);
                    }
                    if (entry.getSize() == 0L) {
                        if (!Files.exists(output_path, new LinkOption[0])) {
                            LOG.debug("create empty: {} -> {}", (Object)entry.getName(), (Object)output_path);
                            Files.createFile(output_path, new FileAttribute[0]);
                        }
                    } else {
                        LOG.debug("copy: {} -> {}", (Object)entry.getName(), (Object)output_path);
                        InputStream input = input_zip.getInputStream(entry);
                        Files.copy(input, output_path, StandardCopyOption.REPLACE_EXISTING);
                    }
                }
                this.unpacked.put(entry.getName(), output_path);
            }
        }
    }

    private static final class Copy {
        private final Path input;
        private final String name;

        private Copy(Path in_input, String in_name) {
            this.input = Objects.requireNonNull(in_input, "input");
            this.name = Objects.requireNonNull(in_name, "name");
        }
    }
}

