/*
 * Decompiled with CFR 0.152.
 */
package one.lfa.opdsget.api;

import java.util.ArrayList;
import java.util.Objects;
import one.lfa.opdsget.api.OPDSSquashConfigurationType;
import org.immutables.value.Generated;

@Generated(from="OPDSSquashConfigurationType", generator="Immutables")
public final class OPDSSquashConfiguration
implements OPDSSquashConfigurationType {
    private final double scaleFactor;
    private final double maximumImageWidth;
    private final double maximumImageHeight;

    private OPDSSquashConfiguration(Builder builder) {
        this.maximumImageWidth = builder.maximumImageWidth;
        this.maximumImageHeight = builder.maximumImageHeight;
        this.scaleFactor = builder.scaleFactorIsSet() ? builder.scaleFactor : OPDSSquashConfigurationType.super.scaleFactor();
    }

    @Override
    public double scaleFactor() {
        return this.scaleFactor;
    }

    @Override
    public double maximumImageWidth() {
        return this.maximumImageWidth;
    }

    @Override
    public double maximumImageHeight() {
        return this.maximumImageHeight;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof OPDSSquashConfiguration && this.equalTo((OPDSSquashConfiguration)another);
    }

    private boolean equalTo(OPDSSquashConfiguration another) {
        return Double.doubleToLongBits(this.scaleFactor) == Double.doubleToLongBits(another.scaleFactor) && Double.doubleToLongBits(this.maximumImageWidth) == Double.doubleToLongBits(another.maximumImageWidth) && Double.doubleToLongBits(this.maximumImageHeight) == Double.doubleToLongBits(another.maximumImageHeight);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + Double.hashCode(this.scaleFactor);
        h2 += (h2 << 5) + Double.hashCode(this.maximumImageWidth);
        h2 += (h2 << 5) + Double.hashCode(this.maximumImageHeight);
        return h2;
    }

    public String toString() {
        return "OPDSSquashConfiguration{scaleFactor=" + this.scaleFactor + ", maximumImageWidth=" + this.maximumImageWidth + ", maximumImageHeight=" + this.maximumImageHeight + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="OPDSSquashConfigurationType", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_MAXIMUM_IMAGE_WIDTH = 1L;
        private static final long INIT_BIT_MAXIMUM_IMAGE_HEIGHT = 2L;
        private static final long OPT_BIT_SCALE_FACTOR = 1L;
        private long initBits = 3L;
        private long optBits;
        private double scaleFactor;
        private double maximumImageWidth;
        private double maximumImageHeight;

        private Builder() {
        }

        public final Builder from(OPDSSquashConfigurationType instance) {
            Objects.requireNonNull(instance, "instance");
            this.setScaleFactor(instance.scaleFactor());
            this.setMaximumImageWidth(instance.maximumImageWidth());
            this.setMaximumImageHeight(instance.maximumImageHeight());
            return this;
        }

        public final Builder setScaleFactor(double scaleFactor) {
            this.scaleFactor = scaleFactor;
            this.optBits |= 1L;
            return this;
        }

        public final Builder setMaximumImageWidth(double maximumImageWidth) {
            this.maximumImageWidth = maximumImageWidth;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setMaximumImageHeight(double maximumImageHeight) {
            this.maximumImageHeight = maximumImageHeight;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public OPDSSquashConfiguration build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new OPDSSquashConfiguration(this);
        }

        private boolean scaleFactorIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("maximumImageWidth");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("maximumImageHeight");
            }
            return "Cannot build OPDSSquashConfiguration, some of required attributes are not set " + attributes;
        }
    }
}

