/*
 * Decompiled with CFR 0.152.
 */
package one.lfa.opdsget.vanilla;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OPDSArchiver {
    private static final Logger LOG = LoggerFactory.getLogger(OPDSArchiver.class);

    private OPDSArchiver() {
    }

    public static void createArchive(Path directory, Path output, Path output_tmp) throws IOException {
        Objects.requireNonNull(directory, "directory");
        Objects.requireNonNull(output, "output");
        Objects.requireNonNull(output_tmp, "output_tmp");
        List files = Files.walk(directory, new FileVisitOption[0]).filter(path -> Files.isRegularFile(path, new LinkOption[0])).map(directory::relativize).sorted().collect(Collectors.toList());
        Instant instant = Instant.parse("2001-01-01T00:00:00.00Z");
        FileTime time = FileTime.from(instant);
        LOG.debug("create {}", (Object)output_tmp);
        try (ZipOutputStream stream = new ZipOutputStream(Files.newOutputStream(output_tmp, StandardOpenOption.CREATE_NEW));){
            for (Path path2 : files) {
                OPDSArchiver.compressFile(directory, time, stream, path2);
            }
        }
        LOG.debug("rename {} -> {}", (Object)output_tmp, (Object)output);
        Files.move(output_tmp, output, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
        Files.deleteIfExists(output_tmp);
    }

    private static void compressFile(Path directory, FileTime time, ZipOutputStream stream, Path path) throws IOException {
        LOG.debug("compress {}", (Object)path);
        Path real_path = directory.resolve(path).toAbsolutePath();
        ZipEntry entry = new ZipEntry(path.toString());
        entry.setComment("");
        entry.setCreationTime(time);
        entry.setLastAccessTime(time);
        entry.setLastModifiedTime(time);
        entry.setSize(Files.size(real_path));
        stream.putNextEntry(entry);
        try (InputStream input = Files.newInputStream(real_path, new OpenOption[0]);){
            input.transferTo(stream);
        }
        stream.closeEntry();
    }
}

