/*
 * Decompiled with CFR 0.152.
 */
package one.lfa.opdsget.tests.api;

import java.net.URI;
import java.util.List;
import java.util.Optional;
import one.lfa.opdsget.api.OPDSAuthenticationBasic;
import one.lfa.opdsget.api.OPDSAuthenticationPatternMapped;
import one.lfa.opdsget.api.OPDSMatchingAuthentication;
import org.junit.Assert;
import org.junit.Test;

public final class OPDSAuthenticationPatternMappedTest {
    @Test
    public void testEmpty() {
        OPDSAuthenticationPatternMapped empty = OPDSAuthenticationPatternMapped.of(List.of());
        Assert.assertEquals(Optional.empty(), (Object)empty.apply(URI.create("http://www.example.com")));
    }

    @Test
    public void testMatchSimple() {
        OPDSAuthenticationBasic auth = OPDSAuthenticationBasic.of((String)"someone", (String)"abcdefgh");
        OPDSAuthenticationPatternMapped empty = OPDSAuthenticationPatternMapped.of(List.of(OPDSMatchingAuthentication.of((String)"http[s]?://(.*\\.)example\\.com", Optional.of(auth))));
        Assert.assertEquals(Optional.of(auth), (Object)empty.apply(URI.create("http://www.example.com")));
        Assert.assertEquals(Optional.of(auth), (Object)empty.apply(URI.create("https://www.example.com")));
        Assert.assertEquals(Optional.empty(), (Object)empty.apply(URI.create("http://www.example.com/abc")));
        Assert.assertEquals(Optional.empty(), (Object)empty.apply(URI.create("https://www.example.com/")));
    }

    @Test
    public void testMatchMultiple() {
        OPDSAuthenticationBasic auth0 = OPDSAuthenticationBasic.of((String)"0", (String)"0");
        OPDSAuthenticationBasic auth1 = OPDSAuthenticationBasic.of((String)"1", (String)"1");
        OPDSAuthenticationBasic auth2 = OPDSAuthenticationBasic.of((String)"2", (String)"2");
        OPDSAuthenticationPatternMapped empty = OPDSAuthenticationPatternMapped.of(List.of(OPDSMatchingAuthentication.of((String)"http[s]?://(.*\\.)example\\.com/a", Optional.of(auth0)), OPDSMatchingAuthentication.of((String)"http[s]?://(.*\\.)example\\.com/b", Optional.of(auth1)), OPDSMatchingAuthentication.of((String)"http[s]?://(.*\\.)example\\.com/c", Optional.of(auth2))));
        Assert.assertEquals(Optional.of(auth0), (Object)empty.apply(URI.create("http://www.example.com/a")));
        Assert.assertEquals(Optional.of(auth1), (Object)empty.apply(URI.create("https://www.example.com/b")));
        Assert.assertEquals(Optional.of(auth2), (Object)empty.apply(URI.create("http://www.example.com/c")));
        Assert.assertEquals(Optional.empty(), (Object)empty.apply(URI.create("https://www.example.com/d")));
    }
}

