/*
 * Decompiled with CFR 0.152.
 */
package one.lfa.opdsget.tests.api;

import fi.iki.elonen.NanoHTTPD;
import java.net.URI;
import java.util.Optional;
import one.lfa.opdsget.api.OPDSHTTPException;
import one.lfa.opdsget.api.OPDSHTTPType;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;

public abstract class OPDSHTTPContract {
    private NanoHTTPD httpd;
    private Logger logger;

    protected abstract Logger logger();

    protected abstract OPDSHTTPType http();

    @Before
    public void setup() {
        this.logger = this.logger();
    }

    @After
    public void tearDown() {
        if (this.httpd != null) {
            this.httpd.stop();
        }
    }

    @Test(timeout=90000L)
    public final void testRetry() throws Exception {
        this.httpd = new NanoHTTPD(20000){

            public NanoHTTPD.Response serve(NanoHTTPD.IHTTPSession session) {
                OPDSHTTPContract.this.logger.debug("request: {}", (Object)session);
                return NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.SERVICE_UNAVAILABLE, (String)"text/plain", (String)"Bad news");
            }
        };
        this.httpd.start();
        OPDSHTTPType http = this.http();
        Assert.assertThrows(OPDSHTTPException.class, () -> http.get(URI.create("http://localhost:20000/index.html"), Optional.empty()));
    }

    @Test(timeout=90000L)
    public final void testRetryIOException() {
        OPDSHTTPType http = this.http();
        Assert.assertThrows(OPDSHTTPException.class, () -> http.get(URI.create("http://localhost:20000/index.html"), Optional.empty()));
    }
}

