/*
 * Decompiled with CFR 0.152.
 */
package one.lfa.opdsget.tests.api;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import one.lfa.opdsget.api.OPDSAuthenticationBasic;
import one.lfa.opdsget.api.OPDSAuthenticationPatternMapped;
import one.lfa.opdsget.api.OPDSAuthenticationPatternMappedParser;
import one.lfa.opdsget.api.OPDSMatchingAuthentication;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public final class OPDSAuthenticationPatternMappedParserTest {
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Test
    public void testEmpty() throws Exception {
        try (InputStream stream = OPDSAuthenticationPatternMappedParserTest.resourceStream("auth-empty.map");){
            OPDSAuthenticationPatternMapped received = OPDSAuthenticationPatternMappedParser.parse((URI)URI.create("auth-empty.map"), (InputStream)stream);
            OPDSAuthenticationPatternMapped expected = OPDSAuthenticationPatternMapped.of(new ArrayList());
            Assert.assertEquals((Object)expected, (Object)received);
        }
    }

    @Test
    public void testSingleNone() throws Exception {
        try (InputStream stream = OPDSAuthenticationPatternMappedParserTest.resourceStream("auth-single-none.map");){
            OPDSAuthenticationPatternMapped received = OPDSAuthenticationPatternMappedParser.parse((URI)URI.create("auth-single-none.map"), (InputStream)stream);
            OPDSAuthenticationPatternMapped expected = OPDSAuthenticationPatternMapped.of(List.of(OPDSMatchingAuthentication.of((String)".*", Optional.empty())));
            Assert.assertEquals((Object)expected, (Object)received);
        }
    }

    @Test
    public void testMultipleBasic() throws Exception {
        try (InputStream stream = OPDSAuthenticationPatternMappedParserTest.resourceStream("auth-multi-basic.map");){
            OPDSAuthenticationPatternMapped received = OPDSAuthenticationPatternMappedParser.parse((URI)URI.create("auth-multi-basic.map"), (InputStream)stream);
            OPDSAuthenticationPatternMapped expected = OPDSAuthenticationPatternMapped.of(List.of(OPDSMatchingAuthentication.of((String)"http[s]?://(www\\.)?example\\.com", Optional.of(OPDSAuthenticationBasic.of((String)"0", (String)"0"))), OPDSMatchingAuthentication.of((String)"http[s]?://(www\\.)?example\\.com/abc", Optional.of(OPDSAuthenticationBasic.of((String)"1", (String)"1"))), OPDSMatchingAuthentication.of((String)"http[s]?://(www\\.)?example\\.com/def", Optional.of(OPDSAuthenticationBasic.of((String)"2", (String)"2")))));
            Assert.assertEquals((Object)expected, (Object)received);
        }
    }

    @Test
    public void testUnparseable0() throws Exception {
        try (InputStream stream = OPDSAuthenticationPatternMappedParserTest.resourceStream("auth-bad-unparseable-0.map");){
            this.exception.expect(ParseException.class);
            OPDSAuthenticationPatternMappedParser.parse((URI)URI.create("auth-bad-unparseable-0.map"), (InputStream)stream);
        }
    }

    @Test
    public void testUnparseable1() throws Exception {
        try (InputStream stream = OPDSAuthenticationPatternMappedParserTest.resourceStream("auth-bad-unparseable-1.map");){
            this.exception.expect(ParseException.class);
            OPDSAuthenticationPatternMappedParser.parse((URI)URI.create("auth-bad-unparseable-1.map"), (InputStream)stream);
        }
    }

    @Test
    public void testUnparseable2() throws Exception {
        try (InputStream stream = OPDSAuthenticationPatternMappedParserTest.resourceStream("auth-bad-unparseable-2.map");){
            this.exception.expect(ParseException.class);
            OPDSAuthenticationPatternMappedParser.parse((URI)URI.create("auth-bad-unparseable-2.map"), (InputStream)stream);
        }
    }

    private static InputStream resourceStream(String name) {
        try {
            URL url = OPDSAuthenticationPatternMappedParserTest.class.getResource("/one/lfa/opdsget/tests/api/" + name);
            if (url == null) {
                throw new FileNotFoundException(name);
            }
            return url.openStream();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

