/*
 * Decompiled with CFR 0.152.
 */
package one.lfa.opdsget.tests.vanilla;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import one.lfa.opdsget.tests.TestDirectories;
import one.lfa.opdsget.vanilla.OPDSArchiver;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public final class OPDSArchiverTest {
    private Path output;
    private Path file;
    private Path file_tmp;
    private Path files;
    @Rule
    public ExpectedException expected = ExpectedException.none();

    @Before
    public void setUp() throws IOException {
        this.output = TestDirectories.temporaryDirectory();
        this.files = TestDirectories.temporaryDirectory();
        this.file = Files.createTempFile(this.files, "output", ".zip", new FileAttribute[0]);
        this.file_tmp = Files.createTempFile(this.files, "output", ".zip.tmp", new FileAttribute[0]);
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testArchiverEmptyTempExists() throws Exception {
        this.expected.expect(FileAlreadyExistsException.class);
        OPDSArchiver.createArchive((Path)this.output, (Path)this.file, (Path)this.file_tmp);
    }

    @Test
    public void testArchiverEmpty() throws Exception {
        Files.deleteIfExists(this.file_tmp);
        OPDSArchiver.createArchive((Path)this.output, (Path)this.file, (Path)this.file_tmp);
        Assert.assertTrue((String)(this.file + " must exist"), (boolean)Files.exists(this.file, new LinkOption[0]));
        Assert.assertTrue((String)(this.file_tmp + " must not exist"), (!Files.exists(this.file_tmp, new LinkOption[0]) ? 1 : 0) != 0);
        ZipFile zip = new ZipFile(this.file.toFile());
        List entries = zip.stream().collect(Collectors.toList());
        Assert.assertEquals((String)"Must have no entries", (long)0L, (long)entries.size());
    }

    @Test
    public void testArchiverBasic() throws Exception {
        Files.deleteIfExists(this.file_tmp);
        Files.write(this.output.resolve("hello0.txt"), "Hello 0".getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        Files.write(this.output.resolve("hello1.txt"), "Hello 1".getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        Files.write(this.output.resolve("hello2.txt"), "Hello 2".getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        OPDSArchiver.createArchive((Path)this.output, (Path)this.file, (Path)this.file_tmp);
        ZipFile zip = new ZipFile(this.file.toFile());
        List entries = zip.stream().collect(Collectors.toList());
        Assert.assertTrue((boolean)((ZipEntry)entries.get(0)).getName().contains("hello0.txt"));
        Assert.assertTrue((boolean)((ZipEntry)entries.get(1)).getName().contains("hello1.txt"));
        Assert.assertTrue((boolean)((ZipEntry)entries.get(2)).getName().contains("hello2.txt"));
        Assert.assertEquals((Object)"Hello 0", (Object)new String(zip.getInputStream((ZipEntry)entries.get(0)).readAllBytes(), StandardCharsets.UTF_8));
        Assert.assertEquals((Object)"Hello 1", (Object)new String(zip.getInputStream((ZipEntry)entries.get(1)).readAllBytes(), StandardCharsets.UTF_8));
        Assert.assertEquals((Object)"Hello 2", (Object)new String(zip.getInputStream((ZipEntry)entries.get(2)).readAllBytes(), StandardCharsets.UTF_8));
    }
}

