/*
 * Decompiled with CFR 0.152.
 */
package one.lfa.opdsget.tests.api;

import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import one.lfa.opdsget.api.OPDSLocalFile;
import one.lfa.opdsget.api.OPDSURIRewriters;
import org.junit.Assert;
import org.junit.Test;

public final class OPDSURIRewritersTest {
    @Test
    public void testNamedRewrite0() {
        Optional<OPDSLocalFile> sourceFile = Optional.of(OPDSLocalFile.of((URI)URI.create("http://example.com/feed.atom"), (Path)Paths.get("examples/feeds/xyz.atom", new String[0])));
        OPDSLocalFile targetFile = OPDSLocalFile.of((URI)URI.create("http://example.com/feed.atom"), (Path)Paths.get("examples/feeds/xyz.atom", new String[0]));
        URI output = OPDSURIRewriters.namedSchemeRewriter((String)"example", (Path)Paths.get("examples", new String[0])).rewrite(sourceFile, targetFile);
        Assert.assertEquals((Object)URI.create("example://feeds/xyz.atom"), (Object)output);
    }

    @Test
    public void testNamedRewrite1() {
        Optional sourceFile = Optional.empty();
        OPDSLocalFile targetFile = OPDSLocalFile.of((URI)URI.create("http://example.com/feed.atom"), (Path)Paths.get("examples/feeds/xyz.atom", new String[0]));
        URI output = OPDSURIRewriters.namedSchemeRewriter((String)"example", (Path)Paths.get("examples", new String[0])).rewrite(sourceFile, targetFile);
        Assert.assertEquals((Object)URI.create("example://feeds/xyz.atom"), (Object)output);
    }

    @Test
    public void testRelativize0() {
        Optional<OPDSLocalFile> sourceFile = Optional.of(OPDSLocalFile.of((URI)URI.create("http://example.com/feed.atom"), (Path)Paths.get("examples/feeds/abc.atom", new String[0])));
        OPDSLocalFile targetFile = OPDSLocalFile.of((URI)URI.create("http://example.com/feed.atom"), (Path)Paths.get("examples/feeds/xyz.atom", new String[0]));
        URI result = OPDSURIRewriters.relativeRewriter().rewrite(sourceFile, targetFile);
        Assert.assertEquals((Object)URI.create("xyz.atom"), (Object)result);
    }

    @Test
    public void testRelativize1() {
        Optional sourceFile = Optional.empty();
        OPDSLocalFile targetFile = OPDSLocalFile.of((URI)URI.create("http://example.com/feed.atom"), (Path)Paths.get("examples/feeds/xyz.atom", new String[0]));
        URI result = OPDSURIRewriters.relativeRewriter().rewrite(sourceFile, targetFile);
        Assert.assertEquals((Object)URI.create("feeds/xyz.atom"), (Object)result);
    }
}

