/*
 * Decompiled with CFR 0.152.
 */
package one.lfa.opdsget.tests.vanilla;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import one.lfa.opdsget.api.OPDSDocumentProcessed;
import one.lfa.opdsget.api.OPDSGetConfiguration;
import one.lfa.opdsget.tests.TestDirectories;
import one.lfa.opdsget.vanilla.OPDSDocumentProcessor;
import one.lfa.opdsget.vanilla.OPDSXMLParsers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class OPDSDocumentProcessorTest {
    private OPDSDocumentProcessor processor;
    private Path output;
    private XPathFactory xpath_factory;
    private XPath xpath;
    private XPathExpression xpath_links;
    private XPathExpression xpath_updated;

    @Before
    public void setUp() throws IOException {
        this.output = TestDirectories.temporaryDirectory();
        this.processor = new OPDSDocumentProcessor();
        this.xpath_factory = XPathFactory.newInstance();
        this.xpath = this.xpath_factory.newXPath();
        try {
            this.xpath_links = this.xpath.compile("//*[local-name()='link' and namespace-uri()='http://www.w3.org/2005/Atom']");
            this.xpath_updated = this.xpath.compile("//*[local-name()='updated' and namespace-uri()='http://www.w3.org/2005/Atom']");
        }
        catch (XPathExpressionException e) {
            throw new IllegalStateException(e);
        }
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testRewriteSimple() throws Exception {
        OPDSGetConfiguration config = OPDSGetConfiguration.builder().setOutput(this.output).setRemoteURI(URI.create("http://www.example.com")).build();
        Document document = OPDSDocumentProcessorTest.parse("links.xml");
        NodeList updateds_before = (NodeList)this.xpath_updated.evaluate(document, XPathConstants.NODESET);
        Assert.assertTrue((String)"Document contains 'updated' elements", ((long)updateds_before.getLength() > 0L ? 1 : 0) != 0);
        NodeList links_before = (NodeList)this.xpath_links.evaluate(document, XPathConstants.NODESET);
        Assert.assertTrue((String)"Document contains more than five links", ((long)links_before.getLength() > 5L ? 1 : 0) != 0);
        OPDSDocumentProcessed result = this.processor.process(config, document);
        Assert.assertTrue((boolean)result.feeds().containsKey(URI.create("http://example.com/1.atom")));
        Assert.assertTrue((boolean)result.feeds().containsKey(URI.create("http://example.com/1.entry")));
        Assert.assertTrue((boolean)result.images().containsKey(URI.create("http://example.com/cover.png")));
        Assert.assertTrue((boolean)result.images().containsKey(URI.create("http://example.com/thumbnail.png")));
        Assert.assertTrue((boolean)result.books().containsKey(URI.create("http://example.com/0.epub")));
        NodeList updateds_after = (NodeList)this.xpath_updated.evaluate(document, XPathConstants.NODESET);
        Assert.assertEquals((String)"Document contains the same number of 'updated' elements", (long)updateds_before.getLength(), (long)updateds_after.getLength());
        for (int index = 0; index < updateds_after.getLength(); ++index) {
            Element e = (Element)updateds_after.item(index);
            Assert.assertEquals((Object)"2000-01-01T00:00:00Z", (Object)e.getTextContent());
        }
        NodeList links_after = (NodeList)this.xpath_links.evaluate(document, XPathConstants.NODESET);
        Assert.assertEquals((String)"Document contains exactly five links", (long)5L, (long)links_after.getLength());
    }

    private static Document parse(String name) throws Exception {
        URL url = OPDSDocumentProcessorTest.class.getResource("/one/lfa/opdsget/tests/vanilla/" + name);
        if (url == null) {
            throw new FileNotFoundException(name);
        }
        try (InputStream stream = url.openStream();){
            Document document = new OPDSXMLParsers().parse(url.toURI(), stream);
            return document;
        }
    }
}

