/*
 * Decompiled with CFR 0.152.
 */
package one.lfa.opdsget.vanilla;

import java.net.URI;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import one.lfa.opdsget.api.OPDSDocumentProcessed;
import one.lfa.opdsget.api.OPDSDocumentProcessorType;
import one.lfa.opdsget.api.OPDSGetConfiguration;
import one.lfa.opdsget.api.OPDSGetKind;
import one.lfa.opdsget.api.OPDSLocalFile;
import one.lfa.opdsget.api.OPDSURIHashing;
import one.lfa.opdsget.api.OPDSURIRewriterType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class OPDSDocumentProcessor
implements OPDSDocumentProcessorType {
    private static final Logger LOG = LoggerFactory.getLogger(OPDSDocumentProcessor.class);
    private final XPathFactory xpath_factory = XPathFactory.newInstance();
    private final XPath xpath = this.xpath_factory.newXPath();
    private final XPathExpression xpath_links;
    private final XPathExpression xpath_updated;
    private final XPathExpression xpath_title;

    public OPDSDocumentProcessor() {
        try {
            this.xpath_links = this.xpath.compile("//*[local-name()='link' and namespace-uri()='http://www.w3.org/2005/Atom']");
            this.xpath_updated = this.xpath.compile("//*[local-name()='updated' and namespace-uri()='http://www.w3.org/2005/Atom']");
            this.xpath_title = this.xpath.compile("//*[local-name()='title' and namespace-uri()='http://www.w3.org/2005/Atom']");
        }
        catch (XPathExpressionException e) {
            throw new IllegalStateException(e);
        }
    }

    private static void rewriteLinkTarget(OPDSURIRewriterType rewriter, Element link, OPDSLocalFile source, OPDSLocalFile target) {
        link.setAttribute("href", rewriter.rewrite(Optional.of(source), target).toString());
    }

    private static void removeElement(Node element) {
        Node parent = element.getParentNode();
        parent.removeChild(element);
    }

    private static URI makeAbsolute(URI base, URI input) {
        return base.resolve(input);
    }

    private static URI constructLinkURI(Document document, Element link) {
        return OPDSDocumentProcessor.makeAbsolute(URI.create(document.getDocumentURI()), URI.create(link.getAttribute("href")));
    }

    public OPDSDocumentProcessed process(OPDSGetConfiguration configuration, Document document) throws Exception {
        Objects.requireNonNull(configuration, "configuration");
        Objects.requireNonNull(document, "document");
        HashMap<URI, OPDSLocalFile> feeds = new HashMap<URI, OPDSLocalFile>();
        HashMap<URI, OPDSLocalFile> images = new HashMap<URI, OPDSLocalFile>();
        HashMap<URI, OPDSLocalFile> books = new HashMap<URI, OPDSLocalFile>();
        URI document_uri = URI.create(document.getDocumentURI());
        String hash = OPDSURIHashing.hashOf((URI)document_uri);
        Path file = configuration.feedFile(hash + ".atom");
        OPDSLocalFile currentFile = OPDSLocalFile.of((URI)document_uri, (Path)file);
        Classification classification = this.findTitle(document);
        this.rewriteAndCollectLinks(configuration, currentFile, document, feeds, images, books);
        this.removeUpdatedElements(document);
        return OPDSDocumentProcessed.builder().setFeeds(feeds).setBooks(books).setImages(images).setFile(currentFile).setTitle(classification.title).setEntry(classification.isEntry).build();
    }

    private Classification findTitle(Document document) throws XPathExpressionException {
        Element root = document.getDocumentElement();
        boolean isEntry = Objects.equals(root.getLocalName(), "entry");
        NodeList titles = (NodeList)this.xpath_title.evaluate(document, XPathConstants.NODESET);
        String title = titles.getLength() > 0 ? titles.item(0).getTextContent() : "";
        return new Classification(isEntry, title);
    }

    private void rewriteAndCollectLinks(OPDSGetConfiguration configuration, OPDSLocalFile source, Document document, Map<URI, OPDSLocalFile> feeds, Map<URI, OPDSLocalFile> images, Map<URI, OPDSLocalFile> books) throws XPathExpressionException {
        NodeList links = (NodeList)this.xpath_links.evaluate(document, XPathConstants.NODESET);
        OPDSURIRewriterType rewriter = configuration.uriRewriter();
        block17: for (int index = 0; index < links.getLength(); ++index) {
            String relation;
            Element link = (Element)links.item(index);
            switch (relation = link.getAttribute("rel")) {
                case "http://opds-spec.org/featured": 
                case "subsection": 
                case "collection": 
                case "alternate": {
                    String type = link.getAttribute("type");
                    if (type != null && type.contains("application/atom+xml")) {
                        URI target = OPDSDocumentProcessor.constructLinkURI(document, link);
                        Path path = configuration.feedFileHashed(target);
                        OPDSLocalFile file = OPDSLocalFile.of((URI)target, (Path)path);
                        feeds.put(target, file);
                        OPDSDocumentProcessor.rewriteLinkTarget(rewriter, link, source, file);
                        continue block17;
                    }
                    LOG.debug("removing link with rel {} and type {}", (Object)relation, (Object)type);
                    OPDSDocumentProcessor.removeElement(link);
                    continue block17;
                }
                case "next": {
                    URI target = OPDSDocumentProcessor.constructLinkURI(document, link);
                    Path path = configuration.feedFileHashed(target);
                    OPDSLocalFile file = OPDSLocalFile.of((URI)target, (Path)path);
                    feeds.put(target, file);
                    OPDSDocumentProcessor.rewriteLinkTarget(rewriter, link, source, file);
                    continue block17;
                }
                case "http://opds-spec.org/image": 
                case "http://opds-spec.org/image/thumbnail": {
                    if (!configuration.fetchedKinds().contains(OPDSGetKind.OPDS_GET_IMAGES)) continue block17;
                    URI target = OPDSDocumentProcessor.constructLinkURI(document, link);
                    Path path = configuration.imageFileHashed(target);
                    OPDSLocalFile file = OPDSLocalFile.of((URI)target, (Path)path);
                    images.put(target, file);
                    OPDSDocumentProcessor.rewriteLinkTarget(rewriter, link, source, file);
                    continue block17;
                }
                case "http://opds-spec.org/acquisition": 
                case "http://opds-spec.org/acquisition/open-access": {
                    if (!configuration.fetchedKinds().contains(OPDSGetKind.OPDS_GET_BOOKS)) continue block17;
                    URI target = OPDSDocumentProcessor.constructLinkURI(document, link);
                    Path path = configuration.bookFileHashed(target);
                    OPDSLocalFile file = OPDSLocalFile.of((URI)target, (Path)path);
                    books.put(target, file);
                    OPDSDocumentProcessor.rewriteLinkTarget(rewriter, link, source, file);
                    continue block17;
                }
                default: {
                    LOG.debug("removing link with rel attribute '{}'", (Object)relation);
                    OPDSDocumentProcessor.removeElement(link);
                }
            }
        }
    }

    private void removeUpdatedElements(Document document) throws XPathExpressionException {
        NodeList updateds = (NodeList)this.xpath_updated.evaluate(document, XPathConstants.NODESET);
        for (int index = 0; index < updateds.getLength(); ++index) {
            Element updated = (Element)updateds.item(index);
            updated.setTextContent("2000-01-01T00:00:00Z");
        }
    }

    private static final class Classification {
        private final boolean isEntry;
        private final String title;

        Classification(boolean inIsEntry, String inTitle) {
            this.isEntry = inIsEntry;
            this.title = Objects.requireNonNull(inTitle, "title");
        }
    }
}

