/*
 * Decompiled with CFR 0.152.
 */
package one.lfa.opdsget.vanilla;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Objects;
import java.util.OptionalDouble;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import one.lfa.opdsget.api.OPDSGetConfiguration;
import one.lfa.opdsget.vanilla.OPDSImageScaler;
import one.lfa.opdsget.vanilla.OPDSManifestChangeRequiredType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class OPDSTaskImageScale {
    private static final Logger LOG = LoggerFactory.getLogger(OPDSTaskImageScale.class);
    private final OPDSGetConfiguration configuration;
    private final OPDSManifestChangeRequiredType changeRequired;

    private OPDSTaskImageScale(OPDSGetConfiguration inConfiguration, OPDSManifestChangeRequiredType inChangeRequired) {
        this.configuration = Objects.requireNonNull(inConfiguration, "configuration");
        this.changeRequired = Objects.requireNonNull(inChangeRequired, "inChangeRequired");
    }

    public static CompletionStage<Void> task(OPDSGetConfiguration configuration, OPDSManifestChangeRequiredType inChangeRequired, ExecutorService executor) {
        return CompletableFuture.runAsync(() -> new OPDSTaskImageScale(configuration, inChangeRequired).execute(), executor);
    }

    private void execute() {
        LOG.debug("executing image scale task");
        OptionalDouble scaleOpt = this.configuration.scaleImages();
        if (scaleOpt.isEmpty()) {
            LOG.debug("no scaling value specified, no scaling will be performed");
            return;
        }
        try {
            OPDSImageScaler scaler = new OPDSImageScaler(this.configuration.imageDirectory(), this.changeRequired, scaleOpt.getAsDouble());
            scaler.execute();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

