/*
 * Decompiled with CFR 0.152.
 */
package one.lfa.opdsget.vanilla.parsers.v1;

import com.io7m.blackthorne.api.BTElementHandlerConstructorType;
import com.io7m.blackthorne.api.BTElementHandlerType;
import com.io7m.blackthorne.api.BTElementParsingContextType;
import com.io7m.blackthorne.api.BTQualifiedName;
import java.net.URI;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.UUID;
import one.lfa.opdsget.api.FileEntry;
import one.lfa.opdsget.api.OPDSManifestDescription;
import one.lfa.opdsget.manifest.schema.ManifestSchemas;
import one.lfa.opdsget.vanilla.parsers.v1.OPDSM1FileHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public final class OPDSM1TopLevelHandler
implements BTElementHandlerType<FileEntry, OPDSManifestDescription> {
    private final OPDSManifestDescription.Builder builder = OPDSManifestDescription.builder();

    public OPDSM1TopLevelHandler(BTElementParsingContextType context) {
    }

    public Map<BTQualifiedName, BTElementHandlerConstructorType<?, ? extends FileEntry>> onChildHandlersRequested(BTElementParsingContextType context) {
        return Map.of(BTQualifiedName.of((String)ManifestSchemas.schema1p0Namespace().toString(), (String)"File"), OPDSM1FileHandler::new);
    }

    public void onElementStart(BTElementParsingContextType context, Attributes attributes) throws SAXException {
        try {
            String searchIndex;
            this.builder.setId(UUID.fromString(attributes.getValue("id")));
            this.builder.setRootFile(attributes.getValue("rootFile"));
            this.builder.setUpdated(OffsetDateTime.parse(attributes.getValue("updated")));
            String base = attributes.getValue("base");
            if (base != null) {
                this.builder.setBase(URI.create(base));
            }
            if ((searchIndex = attributes.getValue("searchIndex")) != null) {
                this.builder.setSearchIndex(searchIndex);
            }
        }
        catch (Exception e) {
            throw context.parseException(e);
        }
    }

    public OPDSManifestDescription onElementFinished(BTElementParsingContextType context) throws SAXException {
        try {
            return this.builder.build();
        }
        catch (Exception e) {
            throw context.parseException(e);
        }
    }

    public void onChildValueProduced(BTElementParsingContextType context, FileEntry result) throws SAXException {
        try {
            this.builder.putFiles(URI.create(result.path()), result);
        }
        catch (Exception e) {
            throw context.parseException(e);
        }
    }
}

