/*
 * Decompiled with CFR 0.152.
 */
package one.lfa.opdsget.vanilla;

import com.io7m.blackthorne.api.BTContentHandler;
import com.io7m.blackthorne.api.BTParseError;
import com.io7m.blackthorne.api.BTParseErrorType;
import com.io7m.jlexing.core.LexicalPosition;
import com.io7m.jxe.core.JXEHardenedSAXParsers;
import com.io7m.jxe.core.JXESchemaDefinition;
import com.io7m.jxe.core.JXESchemaResolutionMappings;
import com.io7m.jxe.core.JXEXInclude;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import javax.xml.parsers.ParserConfigurationException;
import one.lfa.opdsget.api.OPDSManifestDescription;
import one.lfa.opdsget.api.OPDSManifestParseError;
import one.lfa.opdsget.api.OPDSManifestParseErrorType;
import one.lfa.opdsget.api.OPDSManifestReaderErrorReceiverType;
import one.lfa.opdsget.api.OPDSManifestReaderType;
import one.lfa.opdsget.manifest.schema.ManifestSchemas;
import one.lfa.opdsget.vanilla.parsers.v1.OPDSM1TopLevelHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public final class OPDSManifestReader
implements OPDSManifestReaderType {
    private static final Logger LOG = LoggerFactory.getLogger(OPDSManifestReader.class);
    private static final JXESchemaDefinition SCHEMA_1_0 = JXESchemaDefinition.builder().setFileIdentifier("schema-1.0.xsd").setLocation(ManifestSchemas.schema1p0URL()).setNamespace(ManifestSchemas.schema1p0Namespace()).build();
    private static final JXESchemaResolutionMappings SCHEMA_MAPPINGS = JXESchemaResolutionMappings.builder().putMappings(SCHEMA_1_0.namespace(), SCHEMA_1_0).build();
    private static final JXEHardenedSAXParsers PARSERS = new JXEHardenedSAXParsers();
    private final SafeErrorPublisher errors;
    private final InputStream inputStream;
    private final URI uri;

    OPDSManifestReader(OPDSManifestReaderErrorReceiverType inErrors, URI inURI, InputStream inInputStream) {
        this.errors = new SafeErrorPublisher(inErrors);
        this.uri = Objects.requireNonNull(inURI, "inURI");
        this.inputStream = Objects.requireNonNull(inInputStream, "inputStream");
    }

    private static OPDSManifestParseError blackthorneToOPDS(URI uri, BTParseError error) {
        return OPDSManifestParseError.builder().setException(error.exception()).setLexical(error.lexical()).setMessage(error.message()).setSeverity(OPDSManifestReader.blackthorneSeverityToOPDSSeverity(error.severity())).build();
    }

    private static OPDSManifestParseErrorType.Severity blackthorneSeverityToOPDSSeverity(BTParseErrorType.Severity severity) {
        switch (severity) {
            case WARNING: {
                return OPDSManifestParseErrorType.Severity.WARNING;
            }
            case ERROR: {
                return OPDSManifestParseErrorType.Severity.ERROR;
            }
        }
        throw new IllegalStateException("Unreachable code");
    }

    private static OPDSManifestParseError errorGeneral(URI uri, Exception e) {
        LexicalPosition lexical = e instanceof SAXParseException ? LexicalPosition.builder().setColumn(((SAXParseException)e).getColumnNumber()).setLine(((SAXParseException)e).getLineNumber()).setFile((Object)uri).build() : LexicalPosition.builder().setColumn(0).setLine(0).setFile((Object)uri).build();
        return OPDSManifestParseError.builder().setException(e).setLexical(lexical).setMessage(e.getLocalizedMessage()).setSeverity(OPDSManifestParseErrorType.Severity.ERROR).build();
    }

    public Optional<OPDSManifestDescription> read() {
        try {
            LOG.debug("executing parser for {}", (Object)this.uri);
            XMLReader parser = PARSERS.createXMLReader(Optional.empty(), JXEXInclude.XINCLUDE_DISABLED, SCHEMA_MAPPINGS);
            InputSource source = new InputSource(this.inputStream);
            String urlText = this.uri.toString();
            source.setPublicId(urlText);
            BTContentHandler contentHandler = BTContentHandler.builder().addHandler(SCHEMA_1_0.namespace().toString(), "Manifest", OPDSM1TopLevelHandler::new).build(this.uri, error -> this.errors.onError(OPDSManifestReader.blackthorneToOPDS(this.uri, error)));
            parser.setErrorHandler((ErrorHandler)contentHandler);
            parser.setContentHandler((ContentHandler)contentHandler);
            parser.parse(source);
            if (this.errors.failed) {
                return Optional.empty();
            }
            return contentHandler.result().map(Function.identity());
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            this.errors.onError(OPDSManifestReader.errorGeneral(this.uri, e));
            return Optional.empty();
        }
    }

    public void close() throws IOException {
    }

    private static final class SafeErrorPublisher
    implements OPDSManifestReaderErrorReceiverType {
        private final OPDSManifestReaderErrorReceiverType errors;
        private boolean failed;

        SafeErrorPublisher(OPDSManifestReaderErrorReceiverType inErrors) {
            this.errors = Objects.requireNonNull(inErrors, "errors");
        }

        public void onError(OPDSManifestParseError error) {
            try {
                switch (error.severity()) {
                    case WARNING: {
                        break;
                    }
                    case ERROR: {
                        this.failed = true;
                    }
                }
                this.errors.onError(error);
            }
            catch (Exception e) {
                LOG.debug("ignored exception raised by receiver: ", (Throwable)e);
            }
        }
    }
}

