/*
 * Decompiled with CFR 0.152.
 */
package one.lfa.opdsget.vanilla;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import one.lfa.epubsquash.api.EPUBSquasherConfiguration;
import one.lfa.epubsquash.api.EPUBSquasherProviderType;
import one.lfa.epubsquash.api.EPUBSquasherType;
import one.lfa.opdsget.api.OPDSGetConfiguration;
import one.lfa.opdsget.api.OPDSSquashConfiguration;
import one.lfa.opdsget.vanilla.OPDSManifestChangeRequiredType;
import one.lfa.opdsget.vanilla.OPDSManifestFileEntryKind;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class OPDSTaskSquash {
    private static final Logger LOG = LoggerFactory.getLogger(OPDSTaskSquash.class);
    private final OPDSGetConfiguration configuration;
    private final EPUBSquasherProviderType squashers;
    private final OPDSManifestChangeRequiredType onChangeRequired;

    private OPDSTaskSquash(OPDSGetConfiguration inConfiguration, EPUBSquasherProviderType inSquashers, OPDSManifestChangeRequiredType inOnChangeRequired) {
        this.configuration = Objects.requireNonNull(inConfiguration, "configuration");
        this.squashers = Objects.requireNonNull(inSquashers, "squashers");
        this.onChangeRequired = Objects.requireNonNull(inOnChangeRequired, "onChangeRequired");
    }

    public static CompletionStage<Void> task(OPDSGetConfiguration configuration, EPUBSquasherProviderType inSquashers, OPDSManifestChangeRequiredType onChangeRequired, ExecutorService executor) {
        return CompletableFuture.runAsync(() -> new OPDSTaskSquash(configuration, inSquashers, onChangeRequired).execute(), executor);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void execute() {
        LOG.debug("executing epub squashing task");
        try {
            Optional squash_opt = this.configuration.squash();
            if (!squash_opt.isPresent()) {
                return;
            }
            OPDSSquashConfiguration squash = (OPDSSquashConfiguration)squash_opt.get();
            if (!Files.isDirectory(this.configuration.bookDirectory(), new LinkOption[0])) {
                return;
            }
            List epubs = Files.list(this.configuration.bookDirectory()).collect(Collectors.toList());
            for (Path epub : epubs) {
                LOG.info("squash: {}", (Object)epub);
                try {
                    EPUBSquasherType squasher = this.squashers.createSquasher(EPUBSquasherConfiguration.builder().setInputFile(epub).setTemporaryDirectory(Files.createTempDirectory("opdsget-retriever-", new FileAttribute[0])).setOutputFile(epub).setScale(squash.scaleFactor()).setMaximumImageHeight(squash.maximumImageHeight()).setMaximumImageWidth(squash.maximumImageWidth()).build());
                    squasher.squash();
                    this.onChangeRequired.onFileChanged(OPDSManifestFileEntryKind.GENERAL, epub.toAbsolutePath());
                }
                catch (Exception e) {
                    LOG.error("failed to squash {}: ", (Object)epub, (Object)e);
                    if (System.getProperty("one.lfa.epubsquash.unsupported.IgnoreSquashErrors") == null) throw e;
                    LOG.warn("ignoring epubsquash errors");
                    continue;
                    return;
                }
            }
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }
}

