/*
 * Decompiled with CFR 0.152.
 */
package one.lfa.opdsget.vanilla;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public final class OPDSXMLParsers {
    private static final Logger LOG = LoggerFactory.getLogger(OPDSXMLParsers.class);
    private final DocumentBuilderFactory builders;

    public OPDSXMLParsers() {
        try {
            this.builders = DocumentBuilderFactory.newDefaultInstance();
            this.builders.setValidating(false);
            this.builders.setNamespaceAware(true);
            this.builders.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document parse(URI uri, InputStream stream) throws ParserConfigurationException, IOException, SAXException {
        Objects.requireNonNull(uri, "uri");
        Objects.requireNonNull(stream, "stream");
        LOG.debug("parse {}", (Object)uri);
        DocumentBuilder builder = this.builders.newDocumentBuilder();
        try {
            Document document = builder.parse(stream, uri.toString());
            return document;
        }
        finally {
            LOG.debug("parsed {}", (Object)uri);
        }
    }
}

