/*
 * Decompiled with CFR 0.152.
 */
package one.lfa.opdsget.vanilla;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Objects;
import javax.imageio.ImageIO;
import one.lfa.opdsget.vanilla.OPDSManifestChangeRequiredType;
import one.lfa.opdsget.vanilla.OPDSManifestFileEntryKind;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OPDSImageScaler {
    private static final Logger LOG = LoggerFactory.getLogger(OPDSImageScaler.class);
    private final Path directory;
    private final OPDSManifestChangeRequiredType changeRequired;
    private final double scale;

    public OPDSImageScaler(Path inDirectory, OPDSManifestChangeRequiredType inChangeRequired, double inScale) {
        this.directory = Objects.requireNonNull(inDirectory, "directory");
        this.changeRequired = Objects.requireNonNull(inChangeRequired, "changeRequired");
        this.scale = inScale;
    }

    private static BufferedImage resize(BufferedImage image, int newWidth, int newHeight) {
        Image tmp = image.getScaledInstance(newWidth, newHeight, 4);
        BufferedImage targetImage = new BufferedImage(newWidth, newHeight, 1);
        Graphics2D g2d = targetImage.createGraphics();
        g2d.drawImage(tmp, 0, 0, null);
        g2d.dispose();
        return targetImage;
    }

    public void execute() throws IOException {
        if (this.scale == 1.0) {
            LOG.info("scaling value is {}, so no scaling required", (Object)this.scale);
            return;
        }
        for (String name : ImageIO.getWriterFormatNames()) {
            LOG.debug("format: {}", (Object)name);
        }
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(this.directory);){
            for (Path path : directoryStream) {
                LOG.debug("scale {}", (Object)path);
                try (BufferedInputStream stream = new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]), 8192);){
                    Path temp;
                    BufferedImage image = ImageIO.read(stream);
                    if (image != null) {
                        int originalWidth = image.getWidth();
                        double width = (double)originalWidth * this.scale;
                        int originalHeight = image.getHeight();
                        double height = (double)originalHeight * this.scale;
                        LOG.info("scale {} {}x{} -> {}x{}", new Object[]{path, originalWidth, originalHeight, width, height});
                        temp = path.resolveSibling(path.getFileName() + ".tmp");
                        BufferedImage newImage = OPDSImageScaler.resize(image, (int)width, (int)height);
                        boolean result = ImageIO.write((RenderedImage)newImage, "jpg", temp.toFile());
                        if (!result) {
                            throw new IOException("ImageIO.write returned false!");
                        }
                    } else {
                        LOG.error("unable to parse image {}", (Object)path);
                        temp = path;
                    }
                    Files.move(temp, path, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
                    this.changeRequired.onFileChanged(OPDSManifestFileEntryKind.GENERAL, path);
                }
            }
        }
    }
}

