/*
 * Decompiled with CFR 0.152.
 */
package one.lfa.opdsget.vanilla;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import one.lfa.opdsget.api.OPDSGetConfiguration;
import one.lfa.opdsget.vanilla.OPDSArchiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class OPDSTaskArchive {
    private static final Logger LOG = LoggerFactory.getLogger(OPDSTaskArchive.class);
    private final OPDSGetConfiguration configuration;

    private OPDSTaskArchive(OPDSGetConfiguration inConfiguration) {
        this.configuration = Objects.requireNonNull(inConfiguration, "configuration");
    }

    public static CompletionStage<Void> task(OPDSGetConfiguration configuration, ExecutorService executor) {
        return CompletableFuture.runAsync(() -> new OPDSTaskArchive(configuration).execute(), executor);
    }

    private static Path temporaryFile(Path path) {
        return Paths.get(new StringBuilder(64).append(path.toString()).append(".tmp").toString(), new String[0]);
    }

    private void execute() {
        LOG.debug("executing archive task");
        try {
            Optional archive_opt = this.configuration.outputArchive();
            if (archive_opt.isPresent()) {
                Path archive = (Path)archive_opt.get();
                LOG.info("zip {} -> {}", (Object)this.configuration.output(), (Object)archive);
                OPDSArchiver.createArchive(this.configuration.output(), archive, OPDSTaskArchive.temporaryFile(archive));
            }
        }
        catch (IOException e) {
            throw new CompletionException(e);
        }
    }
}

