package one.payout.payment.api.model

/**
 * Represents an API response. It contains the status code, raw response body and parsed result.
 * Status code and raw response body is presented even if parsing is not successful.
 *
 * @param T type of the result
 * @property statusCode http status code of the response
 * @property raw raw response body
 * @property result parsed result of the response
 */
data class ApiResponse<T>(
    val statusCode: Int,
    val raw: String,
    val result: Result<T>,
) {
    /** Returns true if the [result] is successful, otherwise false. */
    fun isSuccess(): Boolean = result.isSuccess

    /** Returns true if the [result] failed, otherwise false. */
    fun isFailure(): Boolean = result.isFailure

    /** Returns the [result] if it is successful, otherwise null. */
    fun getOrNull(): T? = result.getOrNull()

    /** Returns the exception from the [result] if it failed, otherwise null. */
    fun exceptionOrNull(): Throwable? = result.exceptionOrNull()

    /** Returns the [result] if it is successful, otherwise throws exception from [result]. */
    fun getOrThrow(): T = result.getOrThrow()
}
