package one.payout.payment.api.model

import one.payout.payment.api.model.CreateCheckoutRequest.StoreCardMode.NO_STORE
import one.payout.payment.api.model.ProductExtensions.totalPrice

data class CreateCheckoutRequest @JvmOverloads constructor(
    val amount: Int,
    val currency: String,
    val customer: Customer,
    val billingAddress: Address,
    val shippingAddress: Address,
    val products: List<Product>,
    val externalId: String,
    val idempotencyKey: String?,
    val metadata: Any?,
    val redirectUrl: String,
    val storeCardMode: StoreCardMode = NO_STORE,
    val rememberedCardToken: String? = null,
    val recurrentCardToken: String? = null,
) {
    init {
        val amountByProducts = products.totalPrice()
        check(amount == amountByProducts) {
            "Amount $amount does not match the sum of products prices ($amountByProducts)"
        }
        check(storeCardMode == NO_STORE || rememberedCardToken == null) {
            "Cannot store card and use remembered card token at the same time"
        }
        check(storeCardMode == NO_STORE || recurrentCardToken == null) {
            "Cannot store card and use recurrent card token at the same time"
        }
        check(rememberedCardToken == null || recurrentCardToken == null) {
            "Cannot use remembered card token and recurrent card token at the same time"
        }
    }

    enum class StoreCardMode {
        NO_STORE,
        STORE_CARD,
        STORE_CARD_FOR_RECURRENT_PAYMENT,
    }
}
