package one.payout.payment.api.model

data class Product(
    val name: String,
    val unitPrice: Int,
    val quantity: Int,
)

object ProductExtensions {
    fun Iterable<Product>.totalPrice(): Int = sumOf { it.unitPrice * it.quantity }
}
