package one.payout.payment.api.model

import com.fasterxml.jackson.databind.JsonNode

data class Webhook(
    val externalId: String,
    val `object`: String,
    val type: String,
    val data: Result<Any>,
) {
    data class PayuToken(
        val cardMask: String,
        val checkoutId: Long,
        val expMonth: String,
        val expYear: String,
        val tokenValue: String,
    )

    data class WebhookCheckout(
        val amount: Int,
        val currency: String,
        val customer: WebhookCustomer,
        val id: Long,
        val externalId: String,
        val metadata: JsonNode?,
        val `object`: String,
        val payment: WebhookPayment?,
        val redirectUrl: String,
        val status: String,
    ) {
        data class WebhookCustomer(
            val firstName: String,
            val lastName: String,
            val email: String,
        )

        data class WebhookPayment(
            val createdAt: Long,
            val failureReason: String,
            val fee: Int,
            val net: Int,
            val `object`: String,
            val paymentMethod: String,
            val status: String,
        )
    }
}
