package one.payout.payment.impl

import one.payout.payment.api.PayoutClient
import java.security.MessageDigest

internal class PayoutSigner(
    private val clientSecretSupplier: PayoutClient.ClientSecretSupplier,
    private val nonceGenerator: PayoutClient.NonceGenerator,
) {
    fun sign(vararg tokens: Any): Signature {
        val nonce = nonceGenerator.generate()
        return Signature(nonce, computeSignature(*tokens, nonce, clientSecretSupplier.get()))
    }

    fun isSignatureValid(nonce: String, signature: String, vararg tokens: Any): Boolean =
        signature == computeSignature(*tokens, nonce, clientSecretSupplier.get())

    @OptIn(ExperimentalStdlibApi::class)
    private fun computeSignature(vararg tokens: Any): String =
        tokens.joinToString(separator = "|").getSha256Digest().toHexString()

    private fun String.getSha256Digest(): ByteArray =
        MessageDigest.getInstance("SHA-256").digest(this.toByteArray())

    data class Signature(val nonce: String, val value: String)
}
