package one.payout.payment.impl.method

import com.fasterxml.jackson.databind.DeserializationFeature
import com.fasterxml.jackson.databind.PropertyNamingStrategies
import com.fasterxml.jackson.module.kotlin.jsonMapper
import com.fasterxml.jackson.module.kotlin.kotlinModule
import io.github.oshai.kotlinlogging.KLogger
import one.payout.payment.api.PayoutClient
import one.payout.payment.api.PayoutClient.PayoutClientException
import one.payout.payment.impl.PayoutAuthorizer
import one.payout.payment.impl.PayoutSigner
import java.net.http.HttpClient

internal abstract class ClientMethod<T, R>(
    private val logger: KLogger,
) {
    companion object {
        val objectMapper =
            jsonMapper {
                addModule(kotlinModule())
                disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES)
                propertyNamingStrategy(PropertyNamingStrategies.SNAKE_CASE)
            }
    }

    @Throws(PayoutClientException::class)
    abstract fun execute(data: R, clientContext: ClientContext): T

    data class ClientContext(
        val authorizer: PayoutAuthorizer,
        val httpClient: HttpClient,
        val baseUrl: String,
        val clientId: String,
        val clientSecretSupplier: PayoutClient.ClientSecretSupplier,
        val signer: PayoutSigner,
    )
}
