package one.payout.payment.impl.method.api

import com.fasterxml.jackson.databind.json.JsonMapper
import com.fasterxml.jackson.module.kotlin.readValue
import io.github.oshai.kotlinlogging.KotlinLogging
import one.payout.payment.api.model.AuthorizeResponse
import one.payout.payment.impl.model.AuthorizeRequest

private val logger = KotlinLogging.logger {}

internal object AuthorizeMethod : ClientApiMethod<AuthorizeResponse, Unit>(
    logger = logger,
    withAuthorization = false,
    requestMethod = "POST",
) {
    override fun getRequestContext(data: Unit, clientContext: ClientContext) =
        "Authorize \"${clientContext.clientId}\""

    override fun getApiPath(data: Unit) = "/api/v1/authorize"

    override fun ExecutionContext<Unit>.createRequestObject() =
        AuthorizeRequest(clientId, clientSecretSupplier.get())
            .also { logger.trace { "Request: ${it.toLogString()}" } }

    override fun logRequestBody(requestBody: String, executionContext: ExecutionContext<Unit>) {}

    override fun logResponse(statusCode: Int, body: String?, executionContext: ExecutionContext<Unit>) {}

    override fun JsonMapper.readResponse(body: String): AuthorizeResponse = readValue(body)

    override fun AuthorizeResponse.onSuccess(executionContext: ExecutionContext<Unit>) {
        logger.info { "Authorization of client was successful" }
    }
}
