package one.payout.payment.impl.method.api

import com.fasterxml.jackson.databind.json.JsonMapper
import com.fasterxml.jackson.module.kotlin.readValue
import io.github.oshai.kotlinlogging.KotlinLogging
import one.payout.payment.api.PayoutClient.PayoutClientException
import one.payout.payment.api.model.Checkout

private val logger = KotlinLogging.logger {}

internal object RetrieveCheckoutMethod : ClientApiMethod<Checkout?, Long>(
    logger = logger,
    on404 = { null },
) {
    override fun getRequestContext(data: Long, clientContext: ClientContext): String = "Retrieve checkout #$data"

    override fun getApiPath(data: Long): String = "/api/v1/checkouts/$data"

    override fun JsonMapper.readResponse(body: String): Checkout? = readValue(body)

    override fun Checkout?.onSuccess(executionContext: ExecutionContext<Long>) {
        if (this != null && !executionContext.signer.isSignatureValid(nonce, signature, amount, currency, externalId)) {
            throw PayoutClientException("Signature of retrieved checkout is invalid")
        }
    }
}
