package one.payout.payment.impl.model

import com.fasterxml.jackson.databind.JsonNode
import com.fasterxml.jackson.databind.annotation.EnumNaming
import one.payout.payment.api.model.Address
import one.payout.payment.api.model.Customer
import one.payout.payment.api.model.Product
import one.payout.util.SnakeCaseEnumNamingStrategy

internal data class CreateCheckoutApiRequest(
    val amount: Int,
    val currency: String,
    val customer: Customer,
    val billingAddress: Address,
    val shippingAddress: Address,
    val products: List<Product>,
    val externalId: String,
    val metadata: JsonNode?,
    val mode: CheckoutMode,
    val recurring: Boolean,
    val nonce: String,
    val cardToken: String?,
    val recurrentToken: String?,
    val redirectUrl: String,
    val signature: String,
) {
    @EnumNaming(SnakeCaseEnumNamingStrategy::class)
    internal enum class CheckoutMode {
        STANDARD,
        STORE_CARD,
        CARD_ON_FILE,
        RECURRENT;
    }
}
