/*
 * Decompiled with CFR 0.152.
 */
package one.payout.payment.impl;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import one.payout.payment.api.PayoutClient;
import one.payout.payment.api.model.ApiResponse;
import one.payout.payment.api.model.AuthorizeResponse;
import one.payout.payment.impl.PayoutAuthorizerKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001:\u0003\u0016\u0017\u0018B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rJ\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\b\u0010\u0015\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lone/payout/payment/impl/PayoutAuthorizer;", "", "authorizeMethod", "Lone/payout/payment/impl/PayoutAuthorizer$AuthorizeMethod;", "<init>", "(Lone/payout/payment/impl/PayoutAuthorizer$AuthorizeMethod;)V", "cache", "Ljava/util/concurrent/atomic/AtomicReference;", "Lone/payout/payment/impl/PayoutAuthorizer$State;", "manualLoaders", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Lone/payout/payment/impl/PayoutAuthorizer$State$Loading;", "authorize", "Lone/payout/payment/api/model/ApiResponse;", "Lone/payout/payment/api/model/AuthorizeResponse;", "getToken", "Lone/payout/payment/impl/PayoutAuthorizer$Token;", "invalidateToken", "", "token", "", "createLoadingState", "AuthorizeMethod", "Token", "State", "payout-payment"})
@SourceDebugExtension(value={"SMAP\nPayoutAuthorizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PayoutAuthorizer.kt\none/payout/payment/impl/PayoutAuthorizer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,109:1\n1#2:110\n*E\n"})
public final class PayoutAuthorizer {
    @NotNull
    private final AuthorizeMethod authorizeMethod;
    @NotNull
    private final AtomicReference<State> cache;
    @NotNull
    private final ConcurrentLinkedQueue<State.Loading> manualLoaders;

    public PayoutAuthorizer(@NotNull AuthorizeMethod authorizeMethod) {
        Intrinsics.checkNotNullParameter((Object)authorizeMethod, (String)"authorizeMethod");
        this.authorizeMethod = authorizeMethod;
        this.cache = new AtomicReference<State.Empty>(State.Empty.INSTANCE);
        this.manualLoaders = new ConcurrentLinkedQueue();
    }

    @NotNull
    public final ApiResponse<AuthorizeResponse> authorize() throws PayoutClient.AuthorizeException {
        Object $this$authorize_u24lambda_u243;
        Object object;
        Object it = object = this.createLoadingState();
        boolean bl = false;
        this.manualLoaders.add((State.Loading)it);
        ((State.Loading)it).getFuture().whenComplete((arg_0, arg_1) -> PayoutAuthorizer.authorize$lambda$2$lambda$1((arg_0, arg_1) -> PayoutAuthorizer.authorize$lambda$2$lambda$0(this, (State.Loading)it, arg_0, arg_1), arg_0, arg_1));
        object = ((State.Loading)object).getFuture();
        try {
            $this$authorize_u24lambda_u243 = object;
            boolean bl2 = false;
            $this$authorize_u24lambda_u243 = Result.constructor-impl((Object)((ApiResponse)((CompletableFuture)$this$authorize_u24lambda_u243).get()));
        }
        catch (Throwable bl2) {
            $this$authorize_u24lambda_u243 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
        }
        object = $this$authorize_u24lambda_u243;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            it = throwable;
            boolean bl3 = false;
            throw new PayoutClient.AuthorizeException("Failed to authorize: " + (Throwable)it, (Throwable)it);
        }
        Object object2 = object;
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getOrElse(...)");
        return (ApiResponse)object2;
    }

    @NotNull
    public final Token getToken() throws PayoutClient.AuthorizeException {
        Object it2;
        Object object;
        State currentState = this.cache.get();
        if (currentState.isValid()) {
            PayoutAuthorizerKt.access$getLogger$p().debug(() -> PayoutAuthorizer.getToken$lambda$5(currentState));
            object = currentState.getToken-d1pmJ48();
            if (Result.isSuccess-impl((Object)object)) {
                String it2 = (String)object;
                boolean bl = false;
                return new Token(it2, false);
            }
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable != null) {
                it2 = throwable;
                Throwable it3 = it2;
                boolean bl = false;
                PayoutAuthorizerKt.access$getLogger$p().debug(() -> PayoutAuthorizer.getToken$lambda$8$lambda$7(it3));
            }
            Result.box-impl((Object)object);
        } else {
            State.Loading manualLoader = this.manualLoaders.peek();
            if (manualLoader != null && this.cache.compareAndSet(currentState, manualLoader)) {
                PayoutAuthorizerKt.access$getLogger$p().debug(PayoutAuthorizer::getToken$lambda$9);
                it2 = manualLoader.getToken-d1pmJ48();
                if (Result.isSuccess-impl((Object)it2)) {
                    String it4 = (String)it2;
                    boolean bl = false;
                    return new Token(it4, false);
                }
                Throwable throwable = Result.exceptionOrNull-impl((Object)it2);
                if (throwable != null) {
                    Throwable it4;
                    Throwable it5 = it4 = throwable;
                    boolean bl = false;
                    PayoutAuthorizerKt.access$getLogger$p().debug(() -> PayoutAuthorizer.getToken$lambda$12$lambda$11(it5));
                }
            }
        }
        object = this.cache.updateAndGet(arg_0 -> PayoutAuthorizer.getToken$lambda$13(currentState, this, arg_0)).getToken-d1pmJ48();
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            it2 = throwable;
            boolean bl = false;
            throw new PayoutClient.AuthorizeException("Failed to authorize: " + (Throwable)it2, (Throwable)it2);
        }
        it2 = (String)object;
        boolean bl = false;
        return new Token((String)it2, true);
    }

    public final void invalidateToken(@NotNull String token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        State currentState = this.cache.get();
        if (currentState instanceof State.Authorization && Intrinsics.areEqual((Object)((State.Authorization)currentState).getAuthorizeResponse().getToken(), (Object)token)) {
            this.cache.compareAndSet(currentState, State.Empty.INSTANCE);
        }
    }

    private final State.Loading createLoadingState() {
        CompletableFuture<ApiResponse<AuthorizeResponse>> future = CompletableFuture.supplyAsync(() -> PayoutAuthorizer.createLoadingState$lambda$19(this)).orTimeout(20L, TimeUnit.SECONDS);
        Intrinsics.checkNotNull(future);
        return new State.Loading(future);
    }

    private static final Unit authorize$lambda$2$lambda$0(PayoutAuthorizer this$0, State.Loading $it, ApiResponse apiResponse, Throwable throwable) {
        this$0.manualLoaders.remove($it);
        return Unit.INSTANCE;
    }

    private static final void authorize$lambda$2$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final Object getToken$lambda$5(State $currentState) {
        return "Reusing valid" + ($currentState instanceof State.Loading ? " loading" : "") + " token";
    }

    private static final Object getToken$lambda$8$lambda$7(Throwable $it) {
        return "Retrying - previous authorization failed: " + $it;
    }

    private static final Object getToken$lambda$9() {
        return "Reusing - manual loader is loading";
    }

    private static final Object getToken$lambda$12$lambda$11(Throwable $it) {
        return "Retrying - previous manual loader failed: " + $it;
    }

    private static final State getToken$lambda$13(State $currentState, PayoutAuthorizer this$0, State it) {
        return Intrinsics.areEqual((Object)it, (Object)$currentState) ? (State)this$0.createLoadingState() : it;
    }

    private static final State createLoadingState$lambda$19$lambda$18$lambda$17$lambda$16(long $startTime, AuthorizeResponse $authorization, State it) {
        return it instanceof State.Authorization && ((State.Authorization)it).getStartTime() >= $startTime ? it : (State)new State.Authorization($startTime, $authorization);
    }

    private static final ApiResponse createLoadingState$lambda$19(PayoutAuthorizer this$0) {
        ApiResponse<AuthorizeResponse> apiResponse;
        block0: {
            long startTime = System.currentTimeMillis();
            ApiResponse<AuthorizeResponse> response = apiResponse = this$0.authorizeMethod.authorize();
            boolean bl = false;
            AuthorizeResponse authorizeResponse = response.getOrNull();
            if (authorizeResponse == null) break block0;
            AuthorizeResponse authorization = authorizeResponse;
            boolean bl2 = false;
            this$0.cache.updateAndGet(arg_0 -> PayoutAuthorizer.createLoadingState$lambda$19$lambda$18$lambda$17$lambda$16(startTime, authorization, arg_0));
        }
        return apiResponse;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u000e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H&\u00a8\u0006\u0005"}, d2={"Lone/payout/payment/impl/PayoutAuthorizer$AuthorizeMethod;", "", "authorize", "Lone/payout/payment/api/model/ApiResponse;", "Lone/payout/payment/api/model/AuthorizeResponse;", "payout-payment"})
    public static interface AuthorizeMethod {
        @NotNull
        public ApiResponse<AuthorizeResponse> authorize();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0003\u000b\f\rB\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H&J\u0015\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H&\u00a2\u0006\u0004\b\t\u0010\n\u0082\u0001\u0003\u000e\u000f\u0010\u00a8\u0006\u0011"}, d2={"Lone/payout/payment/impl/PayoutAuthorizer$State;", "", "<init>", "()V", "isValid", "", "getToken", "Lkotlin/Result;", "", "getToken-d1pmJ48", "()Ljava/lang/Object;", "Empty", "Authorization", "Loading", "Lone/payout/payment/impl/PayoutAuthorizer$State$Authorization;", "Lone/payout/payment/impl/PayoutAuthorizer$State$Empty;", "Lone/payout/payment/impl/PayoutAuthorizer$State$Loading;", "payout-payment"})
    private static abstract class State {
        private State() {
        }

        public abstract boolean isValid();

        @NotNull
        public abstract Object getToken-d1pmJ48();

        public /* synthetic */ State(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0015\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u000f2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\t\u00a8\u0006\u001e"}, d2={"Lone/payout/payment/impl/PayoutAuthorizer$State$Authorization;", "Lone/payout/payment/impl/PayoutAuthorizer$State;", "startTime", "", "authorizeResponse", "Lone/payout/payment/api/model/AuthorizeResponse;", "<init>", "(JLone/payout/payment/api/model/AuthorizeResponse;)V", "getStartTime", "()J", "getAuthorizeResponse", "()Lone/payout/payment/api/model/AuthorizeResponse;", "validUntil", "getValidUntil", "isValid", "", "getToken", "Lkotlin/Result;", "", "getToken-d1pmJ48", "()Ljava/lang/Object;", "component1", "component2", "copy", "equals", "other", "", "hashCode", "", "toString", "payout-payment"})
        public static final class Authorization
        extends State {
            private final long startTime;
            @NotNull
            private final AuthorizeResponse authorizeResponse;
            private final long validUntil;

            public Authorization(long startTime, @NotNull AuthorizeResponse authorizeResponse) {
                Intrinsics.checkNotNullParameter((Object)authorizeResponse, (String)"authorizeResponse");
                super(null);
                this.startTime = startTime;
                this.authorizeResponse = authorizeResponse;
                this.validUntil = this.startTime + Duration.getInWholeMilliseconds-impl((long)DurationKt.toDuration((int)this.authorizeResponse.getValidFor(), (DurationUnit)DurationUnit.SECONDS));
            }

            public final long getStartTime() {
                return this.startTime;
            }

            @NotNull
            public final AuthorizeResponse getAuthorizeResponse() {
                return this.authorizeResponse;
            }

            public final long getValidUntil() {
                return this.validUntil;
            }

            @Override
            public boolean isValid() {
                return System.currentTimeMillis() < this.validUntil;
            }

            @Override
            @NotNull
            public Object getToken-d1pmJ48() {
                return Result.constructor-impl((Object)this.authorizeResponse.getToken());
            }

            public final long component1() {
                return this.startTime;
            }

            @NotNull
            public final AuthorizeResponse component2() {
                return this.authorizeResponse;
            }

            @NotNull
            public final Authorization copy(long startTime, @NotNull AuthorizeResponse authorizeResponse) {
                Intrinsics.checkNotNullParameter((Object)authorizeResponse, (String)"authorizeResponse");
                return new Authorization(startTime, authorizeResponse);
            }

            public static /* synthetic */ Authorization copy$default(Authorization authorization, long l, AuthorizeResponse authorizeResponse, int n, Object object) {
                if ((n & 1) != 0) {
                    l = authorization.startTime;
                }
                if ((n & 2) != 0) {
                    authorizeResponse = authorization.authorizeResponse;
                }
                return authorization.copy(l, authorizeResponse);
            }

            @NotNull
            public String toString() {
                return "Authorization(startTime=" + this.startTime + ", authorizeResponse=" + this.authorizeResponse + ")";
            }

            public int hashCode() {
                int result = Long.hashCode(this.startTime);
                result = result * 31 + this.authorizeResponse.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Authorization)) {
                    return false;
                }
                Authorization authorization = (Authorization)other;
                if (this.startTime != authorization.startTime) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.authorizeResponse, (Object)authorization.authorizeResponse);
            }
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0015\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u0013\u0010\u000b\u001a\u00020\u00052\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\bH\u00d6\u0001\u00a8\u0006\u0011"}, d2={"Lone/payout/payment/impl/PayoutAuthorizer$State$Empty;", "Lone/payout/payment/impl/PayoutAuthorizer$State;", "<init>", "()V", "isValid", "", "getToken", "Lkotlin/Result;", "", "getToken-d1pmJ48", "()Ljava/lang/Object;", "equals", "other", "", "hashCode", "", "toString", "payout-payment"})
        public static final class Empty
        extends State {
            @NotNull
            public static final Empty INSTANCE = new Empty();

            private Empty() {
                super(null);
            }

            @Override
            public boolean isValid() {
                return false;
            }

            @Override
            @NotNull
            public Object getToken-d1pmJ48() {
                return Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new IllegalStateException("Token not available")));
            }

            @NotNull
            public String toString() {
                return "Empty";
            }

            public int hashCode() {
                return -1394546313;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Empty)) {
                    return false;
                }
                Empty cfr_ignored_0 = (Empty)other;
                return true;
            }
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0012\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0015\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0015\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0003H\u00c6\u0003J\u001f\u0010\u0012\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0003H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u000b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u000eH\u00d6\u0001R\u001d\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0019"}, d2={"Lone/payout/payment/impl/PayoutAuthorizer$State$Loading;", "Lone/payout/payment/impl/PayoutAuthorizer$State;", "future", "Ljava/util/concurrent/CompletableFuture;", "Lone/payout/payment/api/model/ApiResponse;", "Lone/payout/payment/api/model/AuthorizeResponse;", "<init>", "(Ljava/util/concurrent/CompletableFuture;)V", "getFuture", "()Ljava/util/concurrent/CompletableFuture;", "isValid", "", "getToken", "Lkotlin/Result;", "", "getToken-d1pmJ48", "()Ljava/lang/Object;", "component1", "copy", "equals", "other", "", "hashCode", "", "toString", "payout-payment"})
        @SourceDebugExtension(value={"SMAP\nPayoutAuthorizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PayoutAuthorizer.kt\none/payout/payment/impl/PayoutAuthorizer$State$Loading\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,109:1\n1#2:110\n*E\n"})
        public static final class Loading
        extends State {
            @NotNull
            private final CompletableFuture<ApiResponse<AuthorizeResponse>> future;

            public Loading(@NotNull CompletableFuture<ApiResponse<AuthorizeResponse>> future) {
                Intrinsics.checkNotNullParameter(future, (String)"future");
                super(null);
                this.future = future;
            }

            @NotNull
            public final CompletableFuture<ApiResponse<AuthorizeResponse>> getFuture() {
                return this.future;
            }

            @Override
            public boolean isValid() {
                return !this.future.isDone();
            }

            @Override
            @NotNull
            public Object getToken-d1pmJ48() {
                Object object;
                CompletableFuture<ApiResponse<AuthorizeResponse>> completableFuture = this.future;
                try {
                    CompletableFuture<ApiResponse<AuthorizeResponse>> $this$getToken_d1pmJ48_u24lambda_u240 = completableFuture;
                    boolean bl = false;
                    Object object2 = $this$getToken_d1pmJ48_u24lambda_u240.get().getResult-d1pmJ48();
                    ResultKt.throwOnFailure((Object)object2);
                    object = Result.constructor-impl((Object)((AuthorizeResponse)object2).getToken());
                }
                catch (Throwable throwable) {
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                return object;
            }

            @NotNull
            public final CompletableFuture<ApiResponse<AuthorizeResponse>> component1() {
                return this.future;
            }

            @NotNull
            public final Loading copy(@NotNull CompletableFuture<ApiResponse<AuthorizeResponse>> future) {
                Intrinsics.checkNotNullParameter(future, (String)"future");
                return new Loading(future);
            }

            public static /* synthetic */ Loading copy$default(Loading loading, CompletableFuture completableFuture, int n, Object object) {
                if ((n & 1) != 0) {
                    completableFuture = loading.future;
                }
                return loading.copy(completableFuture);
            }

            @NotNull
            public String toString() {
                return "Loading(future=" + this.future + ")";
            }

            public int hashCode() {
                return this.future.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Loading)) {
                    return false;
                }
                Loading loading = (Loading)other;
                return Intrinsics.areEqual(this.future, loading.future);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00052\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lone/payout/payment/impl/PayoutAuthorizer$Token;", "", "value", "", "newCreated", "", "<init>", "(Ljava/lang/String;Z)V", "getValue", "()Ljava/lang/String;", "getNewCreated", "()Z", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "payout-payment"})
    public static final class Token {
        @NotNull
        private final String value;
        private final boolean newCreated;

        public Token(@NotNull String value, boolean newCreated) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.value = value;
            this.newCreated = newCreated;
        }

        @NotNull
        public final String getValue() {
            return this.value;
        }

        public final boolean getNewCreated() {
            return this.newCreated;
        }

        @NotNull
        public final String component1() {
            return this.value;
        }

        public final boolean component2() {
            return this.newCreated;
        }

        @NotNull
        public final Token copy(@NotNull String value, boolean newCreated) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return new Token(value, newCreated);
        }

        public static /* synthetic */ Token copy$default(Token token, String string, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                string = token.value;
            }
            if ((n & 2) != 0) {
                bl = token.newCreated;
            }
            return token.copy(string, bl);
        }

        @NotNull
        public String toString() {
            return "Token(value=" + this.value + ", newCreated=" + this.newCreated + ")";
        }

        public int hashCode() {
            int result = this.value.hashCode();
            result = result * 31 + Boolean.hashCode(this.newCreated);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Token)) {
                return false;
            }
            Token token = (Token)other;
            if (!Intrinsics.areEqual((Object)this.value, (Object)token.value)) {
                return false;
            }
            return this.newCreated == token.newCreated;
        }
    }
}

