/*
 * Decompiled with CFR 0.152.
 */
package one.payout.payment.impl;

import java.security.MessageDigest;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.text.Charsets;
import kotlin.text.HexExtensionsKt;
import one.payout.payment.api.PayoutClient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0017B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001f\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u000b\"\u00020\u0001\u00a2\u0006\u0002\u0010\fJ/\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u000b\"\u00020\u0001\u00a2\u0006\u0002\u0010\u0012J!\u0010\u0013\u001a\u00020\u00102\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u000b\"\u00020\u0001H\u0002\u00a2\u0006\u0002\u0010\u0014J\f\u0010\u0015\u001a\u00020\u0016*\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lone/payout/payment/impl/PayoutSigner;", "", "clientSecretSupplier", "Lone/payout/payment/api/PayoutClient$ClientSecretSupplier;", "nonceGenerator", "Lone/payout/payment/api/PayoutClient$NonceGenerator;", "<init>", "(Lone/payout/payment/api/PayoutClient$ClientSecretSupplier;Lone/payout/payment/api/PayoutClient$NonceGenerator;)V", "sign", "Lone/payout/payment/impl/PayoutSigner$Signature;", "tokens", "", "([Ljava/lang/Object;)Lone/payout/payment/impl/PayoutSigner$Signature;", "isSignatureValid", "", "nonce", "", "signature", "(Ljava/lang/String;Ljava/lang/String;[Ljava/lang/Object;)Z", "computeSignature", "([Ljava/lang/Object;)Ljava/lang/String;", "getSha256Digest", "", "Signature", "payout-payment"})
public final class PayoutSigner {
    @NotNull
    private final PayoutClient.ClientSecretSupplier clientSecretSupplier;
    @NotNull
    private final PayoutClient.NonceGenerator nonceGenerator;

    public PayoutSigner(@NotNull PayoutClient.ClientSecretSupplier clientSecretSupplier, @NotNull PayoutClient.NonceGenerator nonceGenerator) {
        Intrinsics.checkNotNullParameter((Object)clientSecretSupplier, (String)"clientSecretSupplier");
        Intrinsics.checkNotNullParameter((Object)nonceGenerator, (String)"nonceGenerator");
        this.clientSecretSupplier = clientSecretSupplier;
        this.nonceGenerator = nonceGenerator;
    }

    @NotNull
    public final Signature sign(Object ... tokens) {
        Intrinsics.checkNotNullParameter((Object)tokens, (String)"tokens");
        String nonce = this.nonceGenerator.generate();
        SpreadBuilder spreadBuilder = new SpreadBuilder(3);
        spreadBuilder.addSpread((Object)tokens);
        spreadBuilder.add((Object)nonce);
        spreadBuilder.add((Object)this.clientSecretSupplier.get());
        return new Signature(nonce, this.computeSignature(spreadBuilder.toArray(new Object[spreadBuilder.size()])));
    }

    public final boolean isSignatureValid(@NotNull String nonce, @NotNull String signature, Object ... tokens) {
        Intrinsics.checkNotNullParameter((Object)nonce, (String)"nonce");
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        Intrinsics.checkNotNullParameter((Object)tokens, (String)"tokens");
        SpreadBuilder spreadBuilder = new SpreadBuilder(3);
        spreadBuilder.addSpread((Object)tokens);
        spreadBuilder.add((Object)nonce);
        spreadBuilder.add((Object)this.clientSecretSupplier.get());
        return Intrinsics.areEqual((Object)signature, (Object)this.computeSignature(spreadBuilder.toArray(new Object[spreadBuilder.size()])));
    }

    private final String computeSignature(Object ... tokens) {
        return HexExtensionsKt.toHexString$default((byte[])this.getSha256Digest(ArraysKt.joinToString$default((Object[])tokens, (CharSequence)"|", null, null, (int)0, null, null, (int)62, null)), null, (int)1, null);
    }

    private final byte[] getSha256Digest(String $this$getSha256Digest) {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        String string = $this$getSha256Digest;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] byArray2 = messageDigest.digest(byArray);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"digest(...)");
        return byArray2;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0013"}, d2={"Lone/payout/payment/impl/PayoutSigner$Signature;", "", "nonce", "", "value", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getNonce", "()Ljava/lang/String;", "getValue", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "payout-payment"})
    public static final class Signature {
        @NotNull
        private final String nonce;
        @NotNull
        private final String value;

        public Signature(@NotNull String nonce, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)nonce, (String)"nonce");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.nonce = nonce;
            this.value = value;
        }

        @NotNull
        public final String getNonce() {
            return this.nonce;
        }

        @NotNull
        public final String getValue() {
            return this.value;
        }

        @NotNull
        public final String component1() {
            return this.nonce;
        }

        @NotNull
        public final String component2() {
            return this.value;
        }

        @NotNull
        public final Signature copy(@NotNull String nonce, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)nonce, (String)"nonce");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return new Signature(nonce, value);
        }

        public static /* synthetic */ Signature copy$default(Signature signature, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = signature.nonce;
            }
            if ((n & 2) != 0) {
                string2 = signature.value;
            }
            return signature.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "Signature(nonce=" + this.nonce + ", value=" + this.value + ")";
        }

        public int hashCode() {
            int result = this.nonce.hashCode();
            result = result * 31 + this.value.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Signature)) {
                return false;
            }
            Signature signature = (Signature)other;
            if (!Intrinsics.areEqual((Object)this.nonce, (Object)signature.nonce)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.value, (Object)signature.value);
        }
    }
}

