/*
 * Decompiled with CFR 0.152.
 */
package one.payout.payment.impl.method.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.net.http.HttpRequest;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import one.payout.payment.api.PayoutClient;
import one.payout.payment.api.model.Checkout;
import one.payout.payment.api.model.CreateCheckoutRequest;
import one.payout.payment.impl.PayoutSigner;
import one.payout.payment.impl.method.ClientMethod;
import one.payout.payment.impl.method.api.ClientApiMethod;
import one.payout.payment.impl.method.api.CreateCheckoutMethodKt;
import one.payout.payment.impl.model.CreateCheckoutApiRequest;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nH\u0014J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003H\u0014J\u0012\u0010\f\u001a\u00020\r*\b\u0012\u0004\u0012\u00020\u00030\u000eH\u0014J\u001a\u0010\u000f\u001a\u00020\u0010*\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u000eH\u0014J\u0014\u0010\u0013\u001a\u00020\u0002*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0007H\u0014J\u001a\u0010\u0016\u001a\u00020\u0010*\u00020\u00022\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u000eH\u0014J\u0014\u0010\u0017\u001a\u00020\r*\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u00a8\u0006\u001a"}, d2={"Lone/payout/payment/impl/method/api/CreateCheckoutMethod;", "Lone/payout/payment/impl/method/api/ClientApiMethod;", "Lone/payout/payment/api/model/Checkout;", "Lone/payout/payment/api/model/CreateCheckoutRequest;", "<init>", "()V", "getRequestContext", "", "data", "clientContext", "Lone/payout/payment/impl/method/ClientMethod$ClientContext;", "getApiPath", "createRequestObject", "Lone/payout/payment/impl/model/CreateCheckoutApiRequest;", "Lone/payout/payment/impl/method/api/ClientApiMethod$ExecutionContext;", "customize", "", "Ljava/net/http/HttpRequest$Builder;", "executionContext", "readResponse", "Lcom/fasterxml/jackson/databind/json/JsonMapper;", "body", "onSuccess", "toApi", "signer", "Lone/payout/payment/impl/PayoutSigner;", "payout-payment"})
@SourceDebugExtension(value={"SMAP\nCreateCheckoutMethod.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CreateCheckoutMethod.kt\none/payout/payment/impl/method/api/CreateCheckoutMethod\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n*L\n1#1,70:1\n1#2:71\n58#3:72\n51#3:73\n*S KotlinDebug\n*F\n+ 1 CreateCheckoutMethod.kt\none/payout/payment/impl/method/api/CreateCheckoutMethod\n*L\n32#1:72\n32#1:73\n*E\n"})
public final class CreateCheckoutMethod
extends ClientApiMethod<Checkout, CreateCheckoutRequest> {
    @NotNull
    public static final CreateCheckoutMethod INSTANCE = new CreateCheckoutMethod();

    private CreateCheckoutMethod() {
        super(CreateCheckoutMethodKt.access$getLogger$p(), false, "POST", null, 10, null);
    }

    @Override
    @NotNull
    protected String getRequestContext(@NotNull CreateCheckoutRequest data, @NotNull ClientMethod.ClientContext clientContext) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)clientContext, (String)"clientContext");
        return data.getClass().getSimpleName() + " for externalId \"" + data.getExternalId() + "\" and idempotencyKey \"" + data.getIdempotencyKey() + "\"";
    }

    @Override
    @NotNull
    protected String getApiPath(@NotNull CreateCheckoutRequest data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return "/api/v1/checkouts";
    }

    @NotNull
    protected CreateCheckoutApiRequest createRequestObject(@NotNull ClientApiMethod.ExecutionContext<CreateCheckoutRequest> $this$createRequestObject) {
        Intrinsics.checkNotNullParameter($this$createRequestObject, (String)"<this>");
        return this.toApi($this$createRequestObject.getData(), $this$createRequestObject.getSigner());
    }

    @Override
    protected void customize(@NotNull HttpRequest.Builder $this$customize, @NotNull ClientApiMethod.ExecutionContext<CreateCheckoutRequest> executionContext) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)$this$customize, (String)"<this>");
            Intrinsics.checkNotNullParameter(executionContext, (String)"executionContext");
            String string = executionContext.getData().getIdempotencyKey();
            if (string == null) break block0;
            String it = string;
            boolean bl = false;
            $this$customize.header("Idempotency-Key", it);
        }
    }

    @Override
    @NotNull
    protected Checkout readResponse(@NotNull JsonMapper $this$readResponse, @NotNull String body) {
        Intrinsics.checkNotNullParameter((Object)$this$readResponse, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        ObjectMapper $this$readValue$iv = (ObjectMapper)$this$readResponse;
        boolean $i$f$readValue = false;
        boolean $i$f$jacksonTypeRef = false;
        return (Checkout)$this$readValue$iv.readValue(body, (TypeReference)new TypeReference<Checkout>(){});
    }

    @Override
    protected void onSuccess(@NotNull Checkout $this$onSuccess, @NotNull ClientApiMethod.ExecutionContext<CreateCheckoutRequest> executionContext) {
        Intrinsics.checkNotNullParameter((Object)$this$onSuccess, (String)"<this>");
        Intrinsics.checkNotNullParameter(executionContext, (String)"executionContext");
        Object[] objectArray = new Object[]{$this$onSuccess.getAmount(), $this$onSuccess.getCurrency(), $this$onSuccess.getExternalId()};
        if (!executionContext.getSigner().isSignatureValid($this$onSuccess.getNonce(), $this$onSuccess.getSignature(), objectArray)) {
            throw new PayoutClient.PayoutClientException("Signature of retrieved checkout is invalid");
        }
    }

    private final CreateCheckoutApiRequest toApi(CreateCheckoutRequest $this$toApi, PayoutSigner signer) {
        CreateCheckoutApiRequest.CheckoutMode mode = $this$toApi.getRecurrentCardToken() != null ? CreateCheckoutApiRequest.CheckoutMode.RECURRENT : ($this$toApi.getRememberedCardToken() != null ? CreateCheckoutApiRequest.CheckoutMode.CARD_ON_FILE : ($this$toApi.getStoreCardMode() != CreateCheckoutRequest.StoreCardMode.NO_STORE ? CreateCheckoutApiRequest.CheckoutMode.STORE_CARD : CreateCheckoutApiRequest.CheckoutMode.STANDARD));
        Object[] objectArray = new Object[]{$this$toApi.getAmount(), $this$toApi.getCurrency(), $this$toApi.getExternalId()};
        PayoutSigner.Signature signature = signer.sign(objectArray);
        return new CreateCheckoutApiRequest($this$toApi.getAmount(), $this$toApi.getCurrency(), $this$toApi.getCustomer(), $this$toApi.getBillingAddress(), $this$toApi.getShippingAddress(), $this$toApi.getProducts(), $this$toApi.getExternalId(), ClientMethod.Companion.getObjectMapper().valueToTree($this$toApi.getMetadata()), mode, $this$toApi.getStoreCardMode() == CreateCheckoutRequest.StoreCardMode.STORE_CARD_FOR_RECURRENT_PAYMENT, signature.getNonce(), $this$toApi.getRememberedCardToken(), $this$toApi.getRecurrentCardToken(), $this$toApi.getRedirectUrl(), signature.getValue());
    }
}

