/*
 * Decompiled with CFR 0.152.
 */
package one.tomorrow.transactionaloutbox.commons;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import one.tomorrow.transactionaloutbox.commons.Longs;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaHeaders {
    private static final Logger logger = LoggerFactory.getLogger(KafkaHeaders.class);
    public static final String HEADERS_SOURCE_NAME = "x-source";
    public static final String HEADERS_SEQUENCE_NAME = "x-sequence";
    public static final String HEADERS_VALUE_TYPE_NAME = "x-value-type";
    public static final String HEADERS_DLT_SOURCE_NAME = "x-deadletter-source";
    public static final String HEADERS_DLT_RETRY_NAME = "x-deadletter-retry";

    public static Map<String, Object> knownHeaders(Headers headers) {
        HashMap<String, Object> res = new HashMap<String, Object>();
        KafkaHeaders.addHeaderIfPresent(HEADERS_VALUE_TYPE_NAME, String::new, headers, res);
        KafkaHeaders.addHeaderIfPresent(HEADERS_SOURCE_NAME, String::new, headers, res);
        KafkaHeaders.addHeaderIfPresent(HEADERS_SEQUENCE_NAME, Longs::toLong, headers, res);
        KafkaHeaders.addHeaderIfPresent(HEADERS_DLT_SOURCE_NAME, String::new, headers, res);
        KafkaHeaders.addHeaderIfPresent(HEADERS_DLT_RETRY_NAME, Longs::toLong, headers, res);
        return res;
    }

    private static void addHeaderIfPresent(String key, Function<byte[], Object> valueTransformer, Headers headers, Map<String, Object> res) {
        Header header = headers.lastHeader(key);
        if (header != null) {
            try {
                res.put(key, valueTransformer.apply(header.value()));
            }
            catch (Exception e) {
                logger.warn("Failed to transform byte array {} for key {}: {}", new Object[]{Arrays.toString(header.value()), key, e.getMessage(), e});
            }
        }
    }
}

