/*
 * Decompiled with CFR 0.152.
 */
package one.tomorrow.transactionaloutbox.commons;

import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import one.tomorrow.kafka.messages.DeserializerMessages;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Deserializer;
import org.springframework.util.ReflectionUtils;

public class KafkaProtobufDeserializer
implements Deserializer<Message> {
    private final Map<String, Class<?>> valueTypes;
    private final boolean throwOnError;

    public KafkaProtobufDeserializer(Iterable<Class<? extends Message>> valueTypes, boolean throwOnError) {
        this.valueTypes = StreamSupport.stream(valueTypes.spliterator(), false).map(this::protoFullNameToClass).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        this.throwOnError = throwOnError;
    }

    public KafkaProtobufDeserializer(Map<String, Class<?>> valueTypes, boolean throwOnError) {
        this.valueTypes = valueTypes;
        this.throwOnError = throwOnError;
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
    }

    public Message deserialize(String topic, byte[] data) {
        return this.getInvalidMessageOrThrow("Headers not available", data);
    }

    public Message deserialize(String topic, Headers headers, byte[] data) {
        String headerValueType = Optional.ofNullable(headers.lastHeader("x-value-type")).map(h -> new String(h.value())).orElse(null);
        if (headerValueType == null) {
            return this.getInvalidMessageOrThrow("No 'x-value-type' header present", data);
        }
        Class<?> clazz = this.valueTypes.get(headerValueType);
        if (clazz == null) {
            if (this.throwOnError) {
                throw new IllegalArgumentException("Unknown type " + headerValueType);
            }
            return DeserializerMessages.UnsupportedMessage.newBuilder().setData(ByteString.copyFrom((byte[])data)).build();
        }
        return this.getMessage(headers, data, clazz);
    }

    private Message getMessage(Headers headers, byte[] data, Class<?> clazz) {
        try {
            if (!Message.class.isAssignableFrom(clazz)) {
                return this.getInvalidMessageOrThrow("Not a supported class: " + clazz, data);
            }
            Method m = ReflectionUtils.findMethod(clazz, (String)"parseFrom", (Class[])new Class[]{byte[].class});
            if (null == m) {
                return this.getInvalidMessageOrThrow("Class " + clazz + " does not provide 'parseFrom(byte[])'", data);
            }
            return (Message)m.invoke(null, new Object[]{data});
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            return this.getInvalidMessageOrThrow("Failed to parse data with class " + clazz, data, e);
        }
    }

    private DeserializerMessages.InvalidMessage getInvalidMessageOrThrow(String error, byte[] data) {
        return this.getInvalidMessageOrThrow(error, data, null);
    }

    private DeserializerMessages.InvalidMessage getInvalidMessageOrThrow(String error, byte[] data, Exception cause) {
        if (this.throwOnError) {
            throw new IllegalArgumentException(error, cause);
        }
        return DeserializerMessages.InvalidMessage.newBuilder().setError(error).setData(ByteString.copyFrom((byte[])data)).build();
    }

    public void close() {
    }

    private AbstractMap.SimpleEntry<String, Class<? extends Message>> protoFullNameToClass(Class<? extends Message> valueTypeClass) {
        try {
            Method getDescriptor = valueTypeClass.getMethod("getDescriptor", new Class[0]);
            String protoFullName = ((Descriptors.Descriptor)getDescriptor.invoke(null, new Object[0])).getFullName();
            return new AbstractMap.SimpleEntry<String, Class<? extends Message>>(protoFullName, valueTypeClass);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

