/*
 * Decompiled with CFR 0.152.
 */
package one.tomorrow.transactionaloutbox.commons;

import eu.rekawek.toxiproxy.Proxy;
import eu.rekawek.toxiproxy.ToxiproxyClient;
import eu.rekawek.toxiproxy.model.ToxicDirection;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import one.tomorrow.transactionaloutbox.commons.ProxiedContainerPorts;
import org.testcontainers.containers.ToxiproxyContainer;

public interface ProxiedContainerSupport {
    public static final String CUT_CONNECTION_DOWNSTREAM = "CUT_CONNECTION_DOWNSTREAM";
    public static final String CUT_CONNECTION_UPSTREAM = "CUT_CONNECTION_UPSTREAM";
    public static final AtomicBoolean isCurrentlyCut = new AtomicBoolean(false);

    public Proxy getProxy();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void setConnectionCut(boolean shouldCutConnection) {
        AtomicBoolean atomicBoolean = isCurrentlyCut;
        synchronized (atomicBoolean) {
            if (shouldCutConnection != isCurrentlyCut.get()) {
                try {
                    if (shouldCutConnection) {
                        this.getProxy().toxics().bandwidth(CUT_CONNECTION_DOWNSTREAM, ToxicDirection.DOWNSTREAM, 0L);
                        this.getProxy().toxics().bandwidth(CUT_CONNECTION_UPSTREAM, ToxicDirection.UPSTREAM, 0L);
                        isCurrentlyCut.set(true);
                    } else {
                        this.getProxy().toxics().get(CUT_CONNECTION_DOWNSTREAM).remove();
                        this.getProxy().toxics().get(CUT_CONNECTION_UPSTREAM).remove();
                        isCurrentlyCut.set(false);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not control proxy", e);
                }
            }
        }
    }

    public static Proxy createProxy(String service, ToxiproxyContainer toxiproxy, int exposedPort) {
        Proxy proxy;
        ToxiproxyClient toxiproxyClient = new ToxiproxyClient(toxiproxy.getHost(), toxiproxy.getControlPort());
        try {
            proxy = toxiproxyClient.createProxy(service, "0.0.0.0:" + ProxiedContainerPorts.findPort(service), service + ":" + exposedPort);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return proxy;
    }
}

