/*
 * Decompiled with CFR 0.152.
 */
package one.tomorrow.transactionaloutbox.commons;

import eu.rekawek.toxiproxy.Proxy;
import one.tomorrow.transactionaloutbox.commons.ProxiedContainerPorts;
import one.tomorrow.transactionaloutbox.commons.ProxiedContainerSupport;
import org.testcontainers.containers.KafkaContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.ToxiproxyContainer;
import org.testcontainers.utility.DockerImageName;

public class ProxiedKafkaContainer
extends KafkaContainer
implements ProxiedContainerSupport {
    private static ProxiedKafkaContainer kafka;
    private static ToxiproxyContainer toxiproxy;
    public static Proxy kafkaProxy;
    public static String bootstrapServers;

    public ProxiedKafkaContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
    }

    public static ProxiedKafkaContainer startProxiedKafka() {
        if (kafka == null) {
            int exposedKafkaPort = 9093;
            Network network = Network.newNetwork();
            kafka = (ProxiedKafkaContainer)((KafkaContainer)((KafkaContainer)new ProxiedKafkaContainer(DockerImageName.parse((String)"confluentinc/cp-kafka:7.1.2")).withExposedPorts(new Integer[]{exposedKafkaPort})).withNetwork(network)).withNetworkAliases(new String[]{"kafka"});
            toxiproxy = (ToxiproxyContainer)new ToxiproxyContainer(DockerImageName.parse((String)"ghcr.io/shopify/toxiproxy:2.5.0")).withNetwork(network);
            toxiproxy.start();
            kafkaProxy = ProxiedContainerSupport.createProxy("kafka", toxiproxy, exposedKafkaPort);
            bootstrapServers = "PLAINTEXT://" + toxiproxy.getHost() + ":" + toxiproxy.getMappedPort(ProxiedContainerPorts.findPort("kafka"));
            kafka.start();
        }
        return kafka;
    }

    public static void stopProxiedKafka() {
        if (toxiproxy != null) {
            toxiproxy.stop();
        }
        if (kafka != null) {
            kafka.stop();
        }
    }

    public String getBootstrapServers() {
        return bootstrapServers;
    }

    @Override
    public Proxy getProxy() {
        return kafkaProxy;
    }
}

