/*
 * Decompiled with CFR 0.152.
 */
package one.tomorrow.transactionaloutbox.commons.spring;

import one.tomorrow.transactionaloutbox.commons.spring.ConditionalOnClass;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;

public class OnClassCondition
implements Condition {
    public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
        String className = metadata.getAnnotations().get(ConditionalOnClass.class).getString("value");
        try {
            ClassLoader beanClassLoader;
            ConfigurableListableBeanFactory beanFactory = context.getBeanFactory();
            if (beanFactory != null && (beanClassLoader = beanFactory.getBeanClassLoader()) != null) {
                beanClassLoader.loadClass(className);
                return true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return false;
    }
}

