/*
 * Decompiled with CFR 0.152.
 */
package one.tomorrow.transactionaloutbox.commons;

import eu.rekawek.toxiproxy.Proxy;
import one.tomorrow.transactionaloutbox.commons.ProxiedContainerPorts;
import one.tomorrow.transactionaloutbox.commons.ProxiedContainerSupport;
import org.jetbrains.annotations.NotNull;
import org.springframework.test.context.DynamicPropertyRegistry;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.PostgreSQLContainer;
import org.testcontainers.containers.ToxiproxyContainer;
import org.testcontainers.utility.DockerImageName;

public class ProxiedPostgreSQLContainer
extends PostgreSQLContainer<ProxiedPostgreSQLContainer>
implements ProxiedContainerSupport {
    private static ProxiedPostgreSQLContainer postgres;
    private static ToxiproxyContainer toxiproxy;
    public static Proxy postgresProxy;
    private static String jdbcUrl;

    public ProxiedPostgreSQLContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
    }

    public static ProxiedPostgreSQLContainer startProxiedPostgres() {
        if (postgres == null) {
            int exposedPostgresPort = POSTGRESQL_PORT;
            Network network = Network.newNetwork();
            postgres = (ProxiedPostgreSQLContainer)((ProxiedPostgreSQLContainer)((ProxiedPostgreSQLContainer)new ProxiedPostgreSQLContainer(DockerImageName.parse((String)"postgres:13.7")).withExposedPorts(new Integer[]{exposedPostgresPort})).withNetwork(network)).withNetworkAliases(new String[]{"postgres"});
            toxiproxy = (ToxiproxyContainer)new ToxiproxyContainer(DockerImageName.parse((String)"ghcr.io/shopify/toxiproxy:2.5.0")).withNetwork(network);
            toxiproxy.start();
            postgresProxy = ProxiedContainerSupport.createProxy("postgres", toxiproxy, exposedPostgresPort);
            jdbcUrl = "jdbc:postgresql://" + ProxiedPostgreSQLContainer.getHostAndPort() + "/" + postgres.getDatabaseName();
            postgres.start();
        }
        return postgres;
    }

    @NotNull
    private static String getHostAndPort() {
        return toxiproxy.getHost() + ":" + toxiproxy.getMappedPort(ProxiedContainerPorts.findPort("postgres"));
    }

    public static void stopProxiedPostgres() {
        if (toxiproxy != null) {
            toxiproxy.stop();
        }
        if (postgres != null) {
            postgres.stop();
        }
    }

    public static void setConnectionProperties(DynamicPropertyRegistry registry) {
        if (postgres == null) {
            ProxiedPostgreSQLContainer.startProxiedPostgres();
        }
        registry.add("spring.r2dbc.url", () -> "r2dbc:postgresql://" + ProxiedPostgreSQLContainer.getHostAndPort() + "/" + postgres.getDatabaseName());
        registry.add("spring.r2dbc.username", () -> postgres.getUsername());
        registry.add("spring.r2dbc.password", () -> postgres.getPassword());
    }

    public String getJdbcUrl() {
        return jdbcUrl;
    }

    @Override
    public Proxy getProxy() {
        return postgresProxy;
    }
}

