/**
 * Copyright 2023 Tomorrow GmbH @ https://tomorrow.one
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *          http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package one.tomorrow.transactionaloutbox.commons.spring;

import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;

public class OnClassCondition implements Condition {

    @Override
    public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
        String className = metadata.getAnnotations().get(ConditionalOnClass.class).getString("value");
        try {
            ConfigurableListableBeanFactory beanFactory = context.getBeanFactory();
            ClassLoader beanClassLoader;
            if (beanFactory != null && (beanClassLoader = beanFactory.getBeanClassLoader()) != null) {
                beanClassLoader.loadClass(className);
                return true;
            }
        } catch (ClassNotFoundException e) {
            // ignore
        }
        return false;
    }

}
