/*
 * Decompiled with CFR 0.152.
 */
package one.tomorrow.transactionaloutbox.commons;

import java.io.IOException;
import java.net.ServerSocket;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxiedContainerPorts {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProxiedContainerPorts.class);
    private static final int FIRST_PROXIED_PORT = 8666;
    private static final int LAST_PROXIED_PORT = 8697;
    private static final AtomicInteger NEXT_PORT = new AtomicInteger(8666);
    private static final Map<String, Integer> PORT_BY_SERVICE = new HashMap<String, Integer>();

    public static int findPort(String service) {
        Integer result = PORT_BY_SERVICE.get(service);
        if (result != null) {
            return result;
        }
        result = ProxiedContainerPorts.findNextPort(NEXT_PORT.getAndIncrement());
        LOGGER.info("Setting port for {} to {}", (Object)service, (Object)result);
        PORT_BY_SERVICE.put(service, result);
        return result;
    }

    private static int findNextPort(int port) {
        int n;
        if (port > 8697) {
            throw new RuntimeException("Could not find free port for proxied container");
        }
        ServerSocket socket = new ServerSocket(port);
        try {
            n = socket.getLocalPort();
        }
        catch (Throwable throwable) {
            try {
                try {
                    socket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                LOGGER.info("Port {} is already in use, trying next port", (Object)port);
                return ProxiedContainerPorts.findNextPort(NEXT_PORT.getAndIncrement());
            }
        }
        socket.close();
        return n;
    }
}

