/*
 * Decompiled with CFR 0.152.
 */
package one.tomorrow.transactionaloutbox.reactive.service;

import com.google.protobuf.Message;
import java.time.Instant;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import one.tomorrow.transactionaloutbox.reactive.model.OutboxRecord;
import one.tomorrow.transactionaloutbox.reactive.repository.OutboxRepository;
import org.springframework.stereotype.Service;
import org.springframework.transaction.ReactiveTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.reactive.TransactionalOperator;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import reactor.core.publisher.Mono;

@Service
public class OutboxService {
    private final OutboxRepository repository;
    private final TransactionalOperator mandatoryTxOperator;

    public OutboxService(OutboxRepository repository, ReactiveTransactionManager tm) {
        this.repository = repository;
        DefaultTransactionDefinition txDefinition = new DefaultTransactionDefinition();
        txDefinition.setPropagationBehavior(2);
        this.mandatoryTxOperator = TransactionalOperator.create((ReactiveTransactionManager)tm, (TransactionDefinition)txDefinition);
    }

    public <T extends Message> Mono<OutboxRecord> saveForPublishing(String topic, String key, T event, Header ... headers) {
        Header valueType = new Header("x-value-type", event.getDescriptorForType().getFullName());
        Map<String, String> headerMap = Stream.concat(Stream.of(valueType), Arrays.stream(headers)).collect(Collectors.toMap(Header::getKey, Header::getValue));
        OutboxRecord record = OutboxRecord.builder().topic(topic).key(key).value(event.toByteArray()).headers(OutboxRecord.toJson(headerMap)).created(Instant.now()).build();
        return (Mono)this.repository.save(record).as(arg_0 -> ((TransactionalOperator)this.mandatoryTxOperator).transactional(arg_0));
    }

    public static class Header {
        private final String key;
        private final String value;

        @Generated
        public String getKey() {
            return this.key;
        }

        @Generated
        public String getValue() {
            return this.value;
        }

        @Generated
        public Header(String key, String value) {
            this.key = key;
            this.value = value;
        }
    }
}

