/*
 * Decompiled with CFR 0.152.
 */
package one.tomorrow.transactionaloutbox.reactive.model;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.r2dbc.postgresql.codec.Json;
import java.io.IOException;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import lombok.Generated;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.Immutable;
import org.springframework.data.relational.core.mapping.Table;

@Table(value="outbox_kafka")
@Immutable
public class OutboxRecord {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    @Id
    private final Long id;
    private final Instant created;
    private final Instant processed;
    private final String topic;
    private final String key;
    private final byte[] value;
    private final Json headers;

    public Map<String, String> getHeadersAsMap() {
        byte[] data;
        byte[] byArray = data = this.headers == null ? null : this.headers.asArray();
        if (data == null || data.length == 0) {
            return Collections.emptyMap();
        }
        try {
            return (Map)OBJECT_MAPPER.readValue(data, (TypeReference)new TypeReference<Map<String, String>>(){});
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Json toJson(Map<String, String> headers) {
        if (headers == null) {
            return null;
        }
        try {
            return Json.of((byte[])OBJECT_MAPPER.writeValueAsBytes(headers));
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Failed to convert to json: " + headers, e);
        }
    }

    @Generated
    public static OutboxRecordBuilder builder() {
        return new OutboxRecordBuilder();
    }

    @Generated
    public OutboxRecordBuilder toBuilder() {
        return new OutboxRecordBuilder().id(this.id).created(this.created).processed(this.processed).topic(this.topic).key(this.key).value(this.value).headers(this.headers);
    }

    @Generated
    public OutboxRecord(Long id, Instant created, Instant processed, String topic, String key, byte[] value, Json headers) {
        this.id = id;
        this.created = created;
        this.processed = processed;
        this.topic = topic;
        this.key = key;
        this.value = value;
        this.headers = headers;
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Instant getCreated() {
        return this.created;
    }

    @Generated
    public Instant getProcessed() {
        return this.processed;
    }

    @Generated
    public String getTopic() {
        return this.topic;
    }

    @Generated
    public String getKey() {
        return this.key;
    }

    @Generated
    public byte[] getValue() {
        return this.value;
    }

    @Generated
    public Json getHeaders() {
        return this.headers;
    }

    @Generated
    public String toString() {
        return "OutboxRecord(id=" + this.getId() + ", created=" + this.getCreated() + ", processed=" + this.getProcessed() + ", topic=" + this.getTopic() + ", key=" + this.getKey() + ", headers=" + this.getHeaders() + ")";
    }

    @Generated
    public static class OutboxRecordBuilder {
        @Generated
        private Long id;
        @Generated
        private Instant created;
        @Generated
        private Instant processed;
        @Generated
        private String topic;
        @Generated
        private String key;
        @Generated
        private byte[] value;
        @Generated
        private Json headers;

        @Generated
        OutboxRecordBuilder() {
        }

        @Generated
        public OutboxRecordBuilder id(Long id) {
            this.id = id;
            return this;
        }

        @Generated
        public OutboxRecordBuilder created(Instant created) {
            this.created = created;
            return this;
        }

        @Generated
        public OutboxRecordBuilder processed(Instant processed) {
            this.processed = processed;
            return this;
        }

        @Generated
        public OutboxRecordBuilder topic(String topic) {
            this.topic = topic;
            return this;
        }

        @Generated
        public OutboxRecordBuilder key(String key) {
            this.key = key;
            return this;
        }

        @Generated
        public OutboxRecordBuilder value(byte[] value) {
            this.value = value;
            return this;
        }

        @Generated
        public OutboxRecordBuilder headers(Json headers) {
            this.headers = headers;
            return this;
        }

        @Generated
        public OutboxRecord build() {
            return new OutboxRecord(this.id, this.created, this.processed, this.topic, this.key, this.value, this.headers);
        }

        @Generated
        public String toString() {
            return "OutboxRecord.OutboxRecordBuilder(id=" + this.id + ", created=" + this.created + ", processed=" + this.processed + ", topic=" + this.topic + ", key=" + this.key + ", value=" + Arrays.toString(this.value) + ", headers=" + this.headers + ")";
        }
    }
}

