/*
 * Decompiled with CFR 0.152.
 */
package one.tomorrow.transactionaloutbox.reactive.service;

import java.time.Duration;
import lombok.Generated;
import one.tomorrow.transactionaloutbox.reactive.repository.OutboxLockRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.reactive.TransactionalOperator;
import reactor.core.publisher.Mono;

@Service
public class OutboxLockService {
    private static final Logger logger = LoggerFactory.getLogger(OutboxLockService.class);
    private final OutboxLockRepository repository;
    private final TransactionalOperator rxtx;

    public Mono<Boolean> acquireOrRefreshLock(String ownerId, Duration lockTimeout, boolean refreshLock) {
        return this.repository.acquireOrRefreshLock(ownerId, lockTimeout, refreshLock);
    }

    public Mono<Void> releaseLock(String ownerId) {
        return this.repository.releaseLock(ownerId);
    }

    public Mono<Boolean> runWithLock(String ownerId, Mono<Void> action) {
        return (Mono)this.repository.preventLockStealing(ownerId).flatMap(outboxLockIsPreventedFromLockStealing -> outboxLockIsPreventedFromLockStealing != false ? action.thenReturn((Object)true) : Mono.just((Object)false)).as(arg_0 -> ((TransactionalOperator)this.rxtx).transactional(arg_0));
    }

    @Generated
    public OutboxLockService(OutboxLockRepository repository, TransactionalOperator rxtx) {
        this.repository = repository;
        this.rxtx = rxtx;
    }
}

