/*
 * Decompiled with CFR 0.152.
 */
package one.tomorrow.transactionaloutbox.reactive.service;

import java.time.Instant;
import java.util.Map;
import one.tomorrow.transactionaloutbox.reactive.model.OutboxRecord;
import one.tomorrow.transactionaloutbox.reactive.repository.OutboxRepository;
import org.springframework.stereotype.Service;
import org.springframework.transaction.ReactiveTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.reactive.TransactionalOperator;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import reactor.core.publisher.Mono;

@Service
public class OutboxService {
    private final OutboxRepository repository;
    private final TransactionalOperator mandatoryTxOperator;

    public OutboxService(OutboxRepository repository, ReactiveTransactionManager tm) {
        this.repository = repository;
        DefaultTransactionDefinition txDefinition = new DefaultTransactionDefinition();
        txDefinition.setPropagationBehavior(2);
        this.mandatoryTxOperator = TransactionalOperator.create((ReactiveTransactionManager)tm, (TransactionDefinition)txDefinition);
    }

    public Mono<OutboxRecord> saveForPublishing(String topic, String key, byte[] event) {
        return this.saveForPublishing(topic, key, event, null);
    }

    public Mono<OutboxRecord> saveForPublishing(String topic, String key, byte[] event, Map<String, String> headerMap) {
        OutboxRecord record = OutboxRecord.builder().topic(topic).key(key).value(event).headers(OutboxRecord.toJson(headerMap)).created(Instant.now()).build();
        return (Mono)this.repository.save(record).as(arg_0 -> ((TransactionalOperator)this.mandatoryTxOperator).transactional(arg_0));
    }
}

