/*
 * Decompiled with CFR 0.152.
 */
package one.tomorrow.transactionaloutbox.reactive.service;

import com.google.protobuf.Message;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import one.tomorrow.transactionaloutbox.commons.spring.ConditionalOnClass;
import one.tomorrow.transactionaloutbox.reactive.model.OutboxRecord;
import one.tomorrow.transactionaloutbox.reactive.service.OutboxService;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
@ConditionalOnClass(value=Message.class)
public class ProtobufOutboxService {
    private final OutboxService outboxService;

    public ProtobufOutboxService(OutboxService outboxService) {
        this.outboxService = outboxService;
    }

    public <T extends Message> Mono<OutboxRecord> saveForPublishing(String topic, String key, T event, Header ... headers) {
        Header valueType = new Header("x-value-type", event.getDescriptorForType().getFullName());
        Map<String, String> headerMap = Stream.concat(Stream.of(valueType), Arrays.stream(headers)).collect(Collectors.toMap(Header::getKey, Header::getValue));
        return this.outboxService.saveForPublishing(topic, key, event.toByteArray(), headerMap);
    }

    public static class Header {
        private final String key;
        private final String value;

        @Generated
        public String getKey() {
            return this.key;
        }

        @Generated
        public String getValue() {
            return this.value;
        }

        @Generated
        public Header(String key, String value) {
            this.key = key;
            this.value = value;
        }
    }
}

