/*
 * Decompiled with CFR 0.152.
 */
package one.tomorrow.transactionaloutbox.repository;

import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import javax.persistence.LockModeType;
import lombok.Generated;
import one.tomorrow.transactionaloutbox.model.OutboxLock;
import one.tomorrow.transactionaloutbox.repository.OutboxSessionFactory;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.dialect.lock.LockingStrategyException;
import org.hibernate.exception.ConstraintViolationException;
import org.hibernate.query.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class OutboxLockRepository {
    private static final Logger logger = LoggerFactory.getLogger(OutboxLockRepository.class);
    private static final LockOptions PESSIMISTIC_NOWAIT = new LockOptions(LockMode.PESSIMISTIC_WRITE).setTimeOut(0);
    private OutboxSessionFactory sessionFactory;

    public boolean acquireOrRefreshLock(String ownerId, Duration timeout) {
        Transaction tx = null;
        OutboxLock lock = null;
        try (Session session = this.sessionFactory.openSession();){
            tx = session.beginTransaction();
            lock = (OutboxLock)session.get(OutboxLock.class, (Serializable)((Object)"outboxLock"));
            if (lock == null) {
                logger.debug("No outbox lock found. Creating one for {}", (Object)ownerId);
                lock = new OutboxLock(ownerId, Instant.now().plus(timeout));
            } else if (ownerId.equals(lock.getOwnerId())) {
                logger.debug("Found outbox lock with requested owner {}, valid until {} - updating lock", (Object)lock.getOwnerId(), (Object)lock.getValidUntil());
                session.buildLockRequest(PESSIMISTIC_NOWAIT).lock((Object)lock);
                lock.setValidUntil(Instant.now().plus(timeout));
            } else {
                if (!ownerId.equals(lock.getOwnerId()) && lock.getValidUntil().isAfter(Instant.now())) {
                    logger.debug("Found outbox lock with owner {}, valid until {}", (Object)lock.getOwnerId(), (Object)lock.getValidUntil());
                    this.tryRollback(tx);
                    boolean bl = false;
                    return bl;
                }
                logger.info("Found expired outbox lock with owner {}, which was valid until {} - grabbing lock for {}", new Object[]{lock.getOwnerId(), lock.getValidUntil(), ownerId});
                session.buildLockRequest(PESSIMISTIC_NOWAIT).lock((Object)lock);
                lock.setOwnerId(ownerId);
                lock.setValidUntil(Instant.now().plus(timeout));
            }
            session.persist((Object)lock);
            session.flush();
            tx.commit();
            logger.info("Acquired or refreshed outbox lock for owner {}, valid until {}", (Object)ownerId, (Object)lock.getValidUntil());
            boolean bl = true;
            return bl;
        }
    }

    private boolean handleException(LockingStrategyException e, String ownerId, OutboxLock lock, Transaction tx) {
        String reason = e.getCause() != null ? e.getCause().toString() : e.toString();
        logger.info("Could not grab lock {} for owner {} - database row is locked: {}", new Object[]{lock, ownerId, reason});
        this.tryRollback(tx);
        return false;
    }

    private boolean handleException(ConstraintViolationException e, String ownerId, Transaction tx) {
        String reason = e.getCause() != null ? e.getCause().toString() : e.toString();
        logger.info("Outbox lock for owner {} could not be created, another one has been created concurrently: {}", (Object)ownerId, (Object)reason);
        this.tryRollback(tx);
        return false;
    }

    private void tryRollback(Transaction tx) {
        if (tx != null) {
            try {
                tx.rollback();
            }
            catch (Exception ex) {
                logger.info("Caught exception while rolling back OutBox transaction", (Throwable)ex);
            }
        }
    }

    public boolean preventLockStealing(String ownerId) {
        Optional lock = this.queryByOwnerId(this.sessionFactory.getCurrentSession(), ownerId).setLockMode(LockModeType.PESSIMISTIC_READ).uniqueResultOptional();
        return lock.isPresent();
    }

    @Transactional
    public void releaseLock(String ownerId) {
        Session session = this.sessionFactory.getCurrentSession();
        this.queryByOwnerId(session, ownerId).uniqueResultOptional().ifPresentOrElse(lock -> {
            session.delete(lock);
            session.flush();
            logger.info("Released outbox lock for owner {}", (Object)ownerId);
        }, () -> logger.debug("Outbox lock for owner {} not found", (Object)ownerId));
    }

    private Query<OutboxLock> queryByOwnerId(Session session, String ownerId) {
        return session.createQuery("FROM OutboxLock WHERE ownerId = :ownerId", OutboxLock.class).setParameter("ownerId", (Object)ownerId);
    }

    @Generated
    public OutboxLockRepository(OutboxSessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }
}

