/*
 * Decompiled with CFR 0.152.
 */
package one.tomorrow.transactionaloutbox.service;

import java.util.HashMap;
import java.util.Map;
import one.tomorrow.transactionaloutbox.service.OutboxProcessor;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.StringSerializer;

public class DefaultKafkaProducerFactory
implements OutboxProcessor.KafkaProducerFactory {
    private final HashMap<String, Object> producerProps;

    public DefaultKafkaProducerFactory(Map<String, Object> producerProps) {
        HashMap<String, Object> props = new HashMap<String, Object>(producerProps);
        DefaultKafkaProducerFactory.setIfNotSet(props, "retries", 10);
        DefaultKafkaProducerFactory.setIfNotSet(props, "max.block.ms", 1000);
        DefaultKafkaProducerFactory.setIfNotSet(props, "max.in.flight.requests.per.connection", 1);
        props.put("key.serializer", StringSerializer.class);
        props.put("value.serializer", ByteArraySerializer.class);
        this.producerProps = props;
    }

    private static void setIfNotSet(Map<String, Object> props, String prop, Object value) {
        if (!props.containsKey(prop)) {
            props.put(prop, value);
        }
    }

    @Override
    public KafkaProducer<String, byte[]> createKafkaProducer() {
        return new KafkaProducer(this.producerProps);
    }

    public String toString() {
        return "DefaultKafkaProducerFactory{producerProps=" + this.producerProps + "}";
    }
}

