/*
 * Decompiled with CFR 0.152.
 */
package one.tomorrow.transactionaloutbox.service;

import com.google.protobuf.Message;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import one.tomorrow.transactionaloutbox.model.OutboxRecord;
import one.tomorrow.transactionaloutbox.repository.OutboxRepository;
import org.springframework.stereotype.Service;

@Service
public class OutboxService {
    private OutboxRepository repository;

    public <T extends Message> OutboxRecord saveForPublishing(String topic, String key, T event, Header ... headers) {
        byte[] value = event.toByteArray();
        Header valueType = new Header("x-value-type", event.getDescriptorForType().getFullName());
        Map<String, String> headerMap = Stream.concat(Stream.of(valueType), Arrays.stream(headers)).collect(Collectors.toMap(Header::getKey, Header::getValue));
        OutboxRecord record = OutboxRecord.builder().topic(topic).key(key).value(value).headers(headerMap).build();
        this.repository.persist(record);
        return record;
    }

    @Generated
    public OutboxService(OutboxRepository repository) {
        this.repository = repository;
    }

    public static class Header {
        private final String key;
        private final String value;

        @Generated
        public String getKey() {
            return this.key;
        }

        @Generated
        public String getValue() {
            return this.value;
        }

        @Generated
        public Header(String key, String value) {
            this.key = key;
            this.value = value;
        }
    }
}

