/*
 * Decompiled with CFR 0.152.
 */
package one.tomorrow.transactionaloutbox.repository;

import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.util.List;
import one.tomorrow.transactionaloutbox.model.OutboxRecord;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class OutboxRepository {
    @PersistenceContext
    private EntityManager entityManager;

    public void persist(OutboxRecord record) {
        this.entityManager.persist((Object)record);
    }

    @Transactional
    public void update(OutboxRecord record) {
        this.entityManager.merge((Object)record);
    }

    @Transactional
    public List<OutboxRecord> getUnprocessedRecords(int limit) {
        return this.entityManager.createQuery("FROM OutboxRecord WHERE processed IS NULL ORDER BY id ASC", OutboxRecord.class).setMaxResults(limit).getResultList();
    }
}

